(function($) {

    $.su = $.su || {};
    $.su.CHAR = $.su.CHAR || {};
    $.su.CHAR.HELP = {
        STATUS_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe informações relevantes sobre a conexão de Rede de Grande Área (Internet)."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "O endereço físico exclusivo atribuído à porta Ethernet (LAN) do roteador."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "O endereço IP atribuído à porta de Internet (WAN) do roteador. O endereço IP é mostrado como 0.0.0.0, isto indica que não há acesso à Internet."
                }, {
                    type: "name",
                    title: "Máscara de Sub-rede",
                    content: "Este parâmetro determina a porção de rede e a porção host de um endereço IP."
                }, {
                    type: "name",
                    title: "Gateway Padrão",
                    content: "O endereço IP utilizado para conectar o roteador à rede."
                }, {
                    type: "name",
                    title: "DNS Primário/DNS Secundário",
                    content: "O DNS (Domain Name System) traduz nomes de host e domínios de Internet para endereços IPs. As informações desses servidores DNS são atribuídas pelo provedor de serviços de Internet (ISP)."
                }, {
                    type: "name",
                    title: "Teste de Conexão",
                    content: "O tipo de conexão atual da porta Internet (WAN)."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "O endereço físico exclusivo atribuído à porta Ethernet (LAN) do roteador."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "O endereço IP atribuído à porta de Internet (WAN) do roteador."
                }, {
                    type: "name",
                    title: "Gateway Padrão",
                    content: "O endereço IP utilizado para conectar o roteador à rede."
                }, {
                    type: "name",
                    title: "DNS Primário/DNS Secundário",
                    content: "O DNS (Domain Name System) traduz nomes de host e domínios de Internet para endereços IPs. As informações desses servidores DNS são atribuídas pelo provedor de serviços de Internet (ISP)."
                }, {
                    type: "name",
                    title: "Teste de Conexão",
                    content: "O tipo de conexão atual da porta Internet (WAN)."
                }
            ]
        },
        STATUS_PLC_NTW: {
            TITLE: "Rede Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Clique no ícone Rede Powerline para exibir a lista de todos os dispositivos conectados através da rede powerline atual."
                }
            ]
        },
        STATUS_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Clique no ícone Powerline para exibir as informações detalhadas do extensor powerline local."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "O identificador exclusivo que é atribuído ao extensor powerline."
                }, {
                    type: "name",
                    title: "Chave Powerline",
                    content: "A chave exclusiva deste dispositivo powerline que é utilizada ao ser adicionada à uma rede powerline. A chave também está impressa no rótulo do produto."
                }, {
                    type: "name",
                    title: "Nome da Rede",
                    content: "O nome da rede que o extensor powerline está. O padrão é HomePlugAV."
                }
            ]
        },
        STATUS_WIRELESS: {
            TITLE: "2.4GHz<span class=\"anti_5g\">/5GHz</span> Rede Wireless",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe o status e as informações básicas da rede wireless."
                }, {
                    type: "name",
                    title: "Status",
                    content: "O status atual (habilitada ou desabilitada) da rede wireless."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Service Set Identifier, também conhecido como nome de rede wireless."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "O canal wireless total."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "O endereço MAC do rádio wireless do extensor powerline."
                }
            ]
        },
        STATUS_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe informações sobre as portas Ethernet (LAN)."
                }, {
                    type: "title",
                    title: "IPv4"
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "O endereço físico exclusivo atribuído à porta Ethernet (LAN) do roteador."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "O endereço IPv4 atribuído à porta Ethernet (LAN) do roteador."
                }, {
                    type: "name",
                    title: "Máscara de Sub-rede",
                    content: "Este parâmetro determina a porção de rede e a porção host de um endereço IP."
                }, {
                    type: "name",
                    title: "DHCP",
                    content: "Exibe se servidor DHCP embutido no roteador está ativo para dispositivos nas portas LAN ou não."
                }, {
                    type: "title",
                    title: "IPv6"
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "O endereço físico exclusivo atribuído à porta Ethernet (LAN) do roteador."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "O endereço IPv6 atribuído à porta (LAN) Internet do roteador."
                }, {
                    type: "name",
                    title: "Endereço de Link-local",
                    content: "O endereço do link IPv6 para a interface LAN."
                }, {
                    type: "name",
                    title: "Tipo Atribuído",
                    content: "O tipo do endereço IPv6 para a interface LAN."
                }
            ]
        },
        STATUS_GUEST: {
            TITLE: "2.4GHz<span class=\"anti_5g\">/5GHz</span> Rede Wireless",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe informações sobre as redes wireless para os convidados."
                }, {
                    type: "name",
                    title: "Status",
                    content: "O status (Habilitada ou Desabilitada) da sua Rede para Convidados."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Mostra o nome da rede wireless da Rede para Convidados."
                }
            ]
        },
        STATUS_USB: {
            TITLE: "Dispositivos USB",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe informações dos dispositivos atuais de armazenamento USB e/ou impressoras conectadas ao roteador através das portas USB ."
                }, {
                    type: "name",
                    title: "Impressora",
                    content: "O nome da impressora conectada."
                }, {
                    type: "name",
                    title: "Total",
                    content: "A capacidade total de armazenamento disponível do dispositivo USB conectado."
                }, {
                    type: "name",
                    title: "Disponível",
                    content: "A capacidade total de armazenamento disponível do dispositivo USB conectado. "
                }
            ]
        },
        STATUS_PERFORMANCE: {
            TITLE: "Desempenho",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe o desempenho do roteador atual"
                }, {
                    type: "name",
                    title: "Carga da CPU",
                    content: "O uso atual da CPU."
                }, {
                    type: "name",
                    title: "Uso da Memória",
                    content: "O uso da memória atual da CPU."
                }
            ]
        },
        STATUS_WIRED: {
            TITLE: "Clientes Cabeados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe informações de todos os dispositivos com fio que estão conectados à rede."
                }
            ]
        },
        STATUS_WIRELESS_CLIENTS: {
            TITLE: "Clientes Wireless",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Clique no ícone de clientes wireless para exibir informações de todos os dispositivos wireless que estão conectados à rede wireless estabelecida pelo extensor powerline ."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "O endereço MAC do cliente wireless."
                }, {
                    type: "name",
                    title: "Banda Wireless",
                    content: "A banda wireless <span class=\"anti_5g\">(2.4GHz ou 5GHz) </span> na qual o cliente está contente."
                }
            ]
        },
        STATUS_WIFI_MOVE: {
            TITLE: "Wi-Fi Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Indica se a função Wi-Fi Move está habilitada ou não."
                }
            ]
        },
        INTERNET_INTERNET: {
            TITLE: "IPv4",
            CONTENT: [
                {
                    type: "title",
                    title: "Tipo de Conexão de Internet: IP Estático"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo caso tenha sido fornecido de um específico endereço IP (fixo), Máscara de Sub-rede, Gateway e parâmetros através do seu provedor."
                }, {
                    type: "name",
                    title: "Endereço IP/Máscara de Sub-rede/Gateway Padrão/DNS Primário/DNS Secundário",
                    content: "Digite as informações fornecidas pelo provedor."
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O padrão e tamanho MTU típico (Maximum Transmission Unit) para a maioria das redes Ethernet é de 1500 bytes. Não é recomendado alterar o tamanho padrão MTU a menos que seja exigido pelo provedor."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: IP Dinâmico"
                }, {
                    type: "paragraph",
                    content: "Selecione essa opção caso tenha sido fornecido com uma conexão de servidor DHCP pelo provedor."
                }, {
                    type: "name",
                    title: "Endereço IP/Máscara de Sub-rede/Gateway Padrão/DNS Primário/DNS Secundário",
                    content: "Estes parâmetros são automaticamente atribuídos pelo servidor DHCP do seu provedor."
                }, {
                    type: "name",
                    title: "Renovar",
                    content: "Clique neste botão para obter novos parâmetros IP do servidor DHCP."
                }, {
                    type: "name",
                    title: "Liberar",
                    content: "Clique para liberar todos os endereços IP atribuídos pelo servidor DHCP."
                }, {
                    type: "name",
                    title: "Utilize os Endereços DNS a seguir",
                    content: "Se o provedor fornece um ou dois endereços DNS, selecione esta opção e digite o DNS Primário e Secundário nos campos correspondentes; caso contrário, os endereços DNS serão atribuídos dinamicamente pelo ISP."
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O padrão e tamanho MTU típico (Maximum Transmission Unit) para a maioria das redes Ethernet é de 1500 bytes. Não é recomendado alterar o tamanho padrão MTU a menos que seja exigido pelo provedor."
                }, {
                    type: "name",
                    title: "Nome Host",
                    content: "Insira um valor para este campo para especificar o nome do host do roteador."
                }, {
                    type: "name",
                    title: "Obter IP utilizando DHCP Unicast",
                    content: "Selecione esta opção se o servidor DHCP do provedor não suporta aplicações de broadcast e você não consegue obter o endereço IP dinamicamente."
                }, {
                    type: "note",
                    title: "Aviso",
                    content: "Se você encontrar error \"Endereço não encontrado\" após inserir os endereços de DNS, é provável que seus servidores DNS são configurados de forma incorreta; entre em contato com o provedor para obter assistência."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: PPPoE"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo se você utilizar o serviço DSL (Digital Subscriber Line) e que são fornecidos com um nome de usuário e senha através do provedor.."
                }, {
                    type: "name",
                    title: "Nome de Usuário/Senha",
                    content: "Insira o Nome de Usuário/Senha oferecidos pelos seu provedor. Estes campos são sensíveis a letras mínusculas e maiúsculas."
                }, {
                    type: "name",
                    title: "Endereço IP de Internet/DNS Primário/DNS Secundário",
                    content: "Estes parâmetros são automaticamente atribuídos pelo servidor DHCP do seu provedor."
                }, {
                    type: "name",
                    title: "Conexão Secundária (Nenhum, IP Dinâmico, IP Estático)",
                    children: [
                        {
                            type: "name",
                            title: "Nenhum",
                            content: "Selecione caso nenhuma conexão secundária seja fornecida."
                        }, {
                            type: "name",
                            title: "IP Dinâmico",
                            content: "Selecione caso o endereço IP e a máscara de sub-rede são atribuídos automaticamente pelo provedor.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renovar",
                                    content: "Clique em Renovar para renovar os parâmetros IP do seu provedor."
                                }, {
                                    type: "name",
                                    title: "Liberar",
                                    content: "Clique neste botão para liberar os parâmetros IP atribuídos."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Selecione se o endereço IP, máscara de sub-rede, gateway e endereços DNS são fornecidos pelo provedor, e insira as informações nos campos correspondentes. "
                        }
                    ]
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O tamanho típico MTUpara redes Ethernet é de 1480 Bytes.",
                    children: [
                        {
                            type: "note",
                            title: "Aviso",
                            content: "Em um caso raro, o provedor pode exigir que você ajuste o tamanho MTU para um melhor desempenho da rede. Você não deve alterar o valor, a menos que seja absolutamente necessário."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Nome de Serviço/Nome de Concentrador de Acesso",
                    content: "Por padrão, o nome do serviço e o nome do concentrador de acesso (AC) são deixados em branco. Esses campos não devem ser configurados a menos que exigido pelo provedor."
                }, {
                    type: "name",
                    title: "Intervalo de Detecção Online",
                    content: "Insira um valor de intervalo entre 0 e 120 (em segundos) para o roteador detectar Concentrador de Acesso online em cada intervalo. O valor padrão é 0, o que significa sem detecção."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Se o seu provedor fornece um endereço IP (fixo) específico, selecione Utilizar o seguinte endereço IP e digite o endereço IP no campo; caso contrário, selecione Obter dinamicamente do provedor para obter um endereço IP atribuído pelo servidor automaticamente."
                }, {
                    type: "name",
                    title: "Endereço DNS/DNS Primário/DNS Secundário",
                    content: "Se o provedor fornece os endereços IP de DNS (fixos) específicos, selecione Utilizar os seguintes endereços de DNS e digite o(s) endereço(s) nos campos DNS primários e  secundários respectivamente; caso contrário selecione Obter Dinamicamente do Provedor para obter endereço(s) IP DNS atribuído(s) pelo(s) servidor(es) automaticamente."
                }, {
                    type: "name",
                    title: "Modo de Conexão",
                    content: "Selecione um modo de conexão apropriado que determina como conectar à Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "Neste modo, a conexão de Internet reconecta automaticamente a qualquer momento que é desconectada."
                        }, {
                            type: "name",
                            title: "Sob Demanda",
                            content: "Neste modo, a conexão de Internet será encerrada automaticamente após um período de inatividade (Max Idle Time) especificado seja alcançado. A conexão é reestabelecida quando você tenta acessar a Internet novamente."
                        }, {
                            type: "name",
                            title: "Por Tempo",
                            content: "Neste modo, a conexão à Internet só é estabelecida em um prazo específico. Se esta opção for selecionada, digite o tempo de início e fim; ambos são no formato HH:MM."
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "Neste modo, a conexão de Internet é controlada manualmente clicando no botão Conectar ou Desconectar. Este modo também suporta a função Max Idle Time (Período Ocioso Máximo). Insira um tempo máximo (em minutos) para quanto a conexão de Internet pode ficar inativa antes de ser finalizada no campo Max Idle Time. O valor padrão é de 15min. Caso deseja que a conexão permaneça sempre ativa, insira 0 (zero)."
                        }, {
                            type: "note",
                            title: "Aviso",
                            content: "O modo de conexão com base no tempo só terá efeito assim que o Horário do Sistema seja configurado em Avançado → Ferramentas de Sistema → Configurações de Horário."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: Cabo BigPond"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo se o provedor fornece conexão de Cabo BigPond."
                }, {
                    type: "name",
                    title: "Nome de Usuário/Senha",
                    content: "Insira o Nome de Usuário/Senha oferecidos pelos seu provedor. Estes campos são sensíveis a letras mínusculas e maiúsculas."
                }, {
                    type: "name",
                    title: "Autent. Servidor",
                    content: "Insira o endereço ou hostname IP do servidor de autenticação."
                }, {
                    type: "name",
                    title: "Autent. Domínio",
                    content: "Insira o sufixo do nome de domínio do servidor (com base na sua localização).  Por exemplo, nsw.bigpond.net.au para NSW/ACT, vic.bigpond.net.au para VIC/TAS/WA/SA/NT, ou qld.bigpond.net.au para QLD."
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O padrão e tamanho MTU típico (Maximum Transmission Unit) para a maioria das redes Ethernet é de 1500 bytes. Não é recomendado alterar o tamanho padrão MTU a menos que seja exigido pelo provedor."
                }, {
                    type: "name",
                    title: "Modo de Conexão",
                    content: "Selecione um modo de conexão apropriado que determina como conectar à Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "Neste modo, a conexão de Internet reconecta automaticamente a qualquer momento que é desconectada."
                        }, {
                            type: "name",
                            title: "Sob Demanda",
                            content: "Neste modo, a conexão de Internet será encerrada automaticamente após um período de inatividade (Max Idle Time) especificado seja alcançado. A conexão é reestabelecida quando você tenta acessar a Internet novamente."
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "Neste modo, a conexão de Internet é controlada manualmente clicando no botão Conectar ou Desconectar. Este modo também suporta a função Max Idle Time (Período Ocioso Máximo). Insira um tempo máximo (em minutos) para quanto a conexão de Internet pode ficar inativa antes de ser finalizada no campo Max Idle Time. O valor padrão é de 15min. Caso deseja que a conexão permaneça sempre ativa, insira 0 (zero)."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: L2TP/PPTP"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo caso conecte um Servidor VPN L2TP/PPTP e seja provido de nome de usuário, senha e Nome de Domínio/Endereço IP do servidor pelo provedor."
                }, {
                    type: "name",
                    title: "Nome de Usuário/Senha",
                    content: "Insira o Nome de Usuário/Senha oferecidos pelos seu provedor. Estes campos são sensíveis a letras mínusculas e maiúsculas."
                }, {
                    type: "name",
                    title: "Endereço IP de Internet/DNS Primário/DNS Secundário",
                    content: "Estes parâmetros serão automaticamente atribuídos pelo servidor DHCP do seu provedor."
                }, {
                    type: "name",
                    title: "Conexão Secundária (IP Dinâmico ou IP Estático)",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinâmico",
                            content: "Selecione caso o endereço IP e a máscara de sub-rede são atribuídos automaticamente pelo provedor.",
                            children: [
                                {
                                    type: "name",
                                    title: "Renovar",
                                    content: "Clique em Renovar para renovar os parâmetros IP do seu provedor."
                                }, {
                                    type: "name",
                                    title: "Liberar",
                                    content: "Clique neste botão para liberar os parâmetros IP atribuídos."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Selecione se o endereço IP, máscara de sub-rede, gateway e endereços DNS são fornecidos pelo provedor, e insira as informações nos campos correspondentes. "
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP de Servidor VPN/Nome de Domínio",
                    content: "Insira um endereço IP de servidor VPN ou nome de domínio oferecido pelo seu provedor."
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O padrão de tamanho MTU típico (Maximum Transmission Unit) para a maioria das redes Ethernet é de 1460 Bytes . Não é recomendado alterar o tamanho padrão MTU a menos que seja exigido pelo provedor."
                }, {
                    type: "name",
                    title: "Modo de Conexão",
                    content: "Selecione um modo de conexão apropriado que determina como conectar à Internet.",
                    children: [
                        {
                            type: "name",
                            title: "Auto",
                            content: "Neste modo, a conexão de Internet reconecta automaticamente a qualquer momento que é desconectada."
                        }, {
                            type: "name",
                            title: "Sob Demanda",
                            content: "Neste modo, a conexão de Internet será encerrada automaticamente após um período de inatividade (Max Idle Time) especificado seja alcançado. A conexão é reestabelecida quando você tenta acessar a Internet novamente."
                        }, {
                            type: "name",
                            title: "Manualmente",
                            content: "Neste modo, a conexão de Internet é controlada manualmente clicando no botão Conectar ou Desconectar. Este modo também suporta a função Max Idle Time (Período Ocioso Máximo). Insira um tempo máximo (em minutos) para quanto a conexão de Internet pode ficar inativa antes de ser finalizada no campo Max Idle Time. O valor padrão é de 15min. Caso deseja que a conexão permaneça sempre ativa, insira 0 (zero)."
                        }
                    ]
                }
            ]
        },
        HELP_PLC_STATION: {
            TITLE: "Lista de Dispositivos Powerline",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe informações de todos os powerlines que pertencem à mesma rede no mesmo circuito elétrico."
                }, {
                    type: "name",
                    title: "Dispositivo Local",
                    content: "O extensor de alcance powerline que você está atualmente logado."
                }, {
                    type: "step",
                    content: ["Na lista de dispositivos powerline, endereço MAC e transmissão de dados do serviço corespondente são mostrados da esquerda para a direita.", "Clique na <b>Lixeira</b> para remover o dispositivo powerline correspondente desta rede.", "Clique no ícone <b>Mais</b> para adicionar um novo extensor de alcance powerline utilizando sua senha de dispositivo para a rede powerline."]
                }, {
                    type: "name",
                    title: "Voltar",
                    content: "Clique para voltar para a página de Status."
                }, {
                    type: "name",
                    title: "Atualizar",
                    content: "Clique para atualizar a página."
                }
            ]
        },
        INTERNET_MAC: {
            TITLE: "Clone de Mac",
            CONTENT: [
                {
                    type: "name",
                    title: "Utilizar Endereço MAC Padrão",
                    content: "NÃO altere o endereço MAC padrão do roteador, caso o provedor não vincula o endereço IP atribuído ao endereço MAC."
                }, {
                    type: "name",
                    title: "Utilizar Endereço MAC do Computador Atual",
                    content: "Selecione para copiar o endereço MAC atual do computador que está conectado ao roteador, caso o provedor vincule o endereço IP atribuído para o endereço do computador MAC."
                }, {
                    type: "name",
                    title: "Utilizar Endereço MAC Personalizado",
                    content: "Digite o endereço MAC manualmente, caso o provedor vincule o endereço IP atribuído ao endereço MAC específico."
                }
            ]
        },
        LAN_IPV4: {
            TITLE: "Configurações LAN",
            CONTENT: [
                {
                    type: "name",
                    title: "Tipo de LAN",
                    content: "Selecione IP Dinâmico ou Estático"
                }, {
                    type: "name",
                    title: "IP Dinâmico",
                    content: "Selecione esta opção para obter automaticamente um endereço IP do servidor DHCP."
                }, {
                    type: "name",
                    title: "IP Estático",
                    content: "Selecione esta opção para especificar manualmente o endereço IP, máscara de sub-rede e gateway padrão."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Exibe o endereço IP do extensor padrão, que é utilizado para efetuar login na página de gerenciamento do extensor, e pode ser substituído."
                }, {
                    type: "name",
                    title: "Máscara de Sub-rede",
                    content: "Escolha um identificador atribuído usado pela porta LAN para rotear tráfego interno e externo na lista flutuante ou insira uma nova máscara de sub-rede na linha pontilhada decimal."
                }, {
                    type: "name",
                    title: "Gateway Padrão",
                    content: "O endereço IP utilizado para conectar o extensor à rede."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Salvar</b> para confirmar as alterações."
                }
            ]
        },
        LED_TIME: {
            TITLE: "Agendamento de LED",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Os Agendamentos de LED permitem que você ligue (ou desligue) os LEDs neste extensor powerline de acordo com um agendamento específico."
                }, {
                    type: "name",
                    title: "Agendamento de LED",
                    content: "Alterne para <b>Habilitar</b> e permitir o recurso de agendamento de LED."
                }
            ]
        },
        LED_TIME_GRID: {
            TITLE: "Agendamento de LED (Desligar)",
            CONTENT: [
                {
                    type: "name",
                    title: "De",
                    content: "Mostra o momento em que o LED está desligado."
                }, {
                    type: "name",
                    title: "Para",
                    content: "Mostra o momento em que o LED está ligado novamente."
                }, {
                    type: "name",
                    title: "Dia(s)",
                    content: "Mostra o(s) dia(s) efetivo(s) da agenda."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Indica o status da agenda correspondente. Clique no ícone <b>Lâmpada</b> (ou desabilitar) o agendamento."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para <b>Modificar</b> ou <b>Apagar</b> a agenda correspondente."
                }, {
                    type: "step",
                    title: "Para criar uma nova agenda",
                    content: ["1. Clique em <b>Adicionar</b>.", "2. Especifique um intervalo de trem para que o LED fique desligado.", "3.  Selecione o(s) dia(s) da semana quando este agendamento estiver efeitvo. ", "4. Selecione <b>Habilitar esta entrada</b>.", "5. Clique em <b>OK</b> para salvar as configurações."]
                }, {
                    type: "paragraph",
                    content: "Para modificar ou apagar uma entrada de Controle dos Pais, clique no ícone <b>Editar</b> ou na <b>Lixeira</b> para apagar a entrada correspondente."
                }, {
                    type: "paragraph",
                    content: "Para apagar múltiplosagendamentos, selecione a caixa de seleção correspondente ao agendamento que se deseja apagar e clique em <b>Apagar</b> acima da tabela."
                }
            ]
        },
        HELP_PLC: {
            TITLE: "Powerline",
            CONTENT: [
                {
                    type: "name",
                    title: "Endereço MAC",
                    content: "O endereço físico exclusivo atribuído ao dispositivo powerline."
                }, {
                    type: "name",
                    title: "Chave Powerline",
                    content: "A chave exclusiva deste dispositivo powerline que é utilizada ao ser adicionada à uma rede powerline. A senha é também impressa no rótulo do produto."
                }, {
                    type: "name",
                    title: "Nome da Rede ",
                    content: "Exibe o nome da rede powerline cujo o extensor de alcance powerline pertence. Você pode renomear a rede aqui ou clicar em Padrão para redefini-la de volta para o nome padrão de fábrica, ou seja, HomePlugAV. Por favor, note que se o nome padrão de fábrica está sendo usado, o recurso Move Wi-Fi será desativado automaticamente."
                }
            ]
        },
        IPTV: {
            TITLE: "Configurações",
            CONTENT: [
                {
                    type: "name",
                    title: "IPTV",
                    content: "Selecione para habilitar a função IPTV."
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Selecione o modo apropriado de acordo com o seu provedor. Há seis modos IPTV suportados:",
                    children: [
                        {
                            type: "name",
                            title: "Bridge",
                            content: " Caso o provedor não esteja listado e nenhum outro parâmetro for solicitado, você pode simplesmente selecionar este modo e configurar a porta LAN do roteador.",
                            children: [
                                {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Atribuir sua porta LAN para que funcione como fornecedor de Internet ou como o fornecedor IPTV."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Rússia",
                            content: "Selecione se o provedor é da Rússia e os parâmetros necessários são predeterminados, incluindo recursos de portas Internet/IP-Phone/IPTV VLAN IDs e Prioridade, e LAN (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "ID VLAN Multicast IPTV/Prioridade",
                                    content: "Você pode ativar o recurso de multicast IPTV conforme desejado além de configurar o ID VLAN e Prioridade de acordo com o provedor."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "Singapore-ExStream",
                            content: "Selecione se o provedor é da ExStream do Singapura e os parâmetros necessários são predeterminados, incluindo recursos de portas Internet/IP-Phone/IPTV VLAN IDs e Prioridade, e LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malaysia-Unifi",
                            content: "Selecione se o provedor é Unifi da Malásia e os parâmetros necessários são predeterminados, incluindo recursos de portas Internet/IP-Phone/IPTV VLAN IDs e Prioridade, e LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Malaysia-Maxis",
                            content: "Selecione se o provedor é Maxis da Malásia e os parâmetros necessários são predeterminados, incluindo recursos de portas Internet/IP-Phone/IPTV VLAN IDs e Prioridade, e LAN (1/2/3/4)."
                        }, {
                            type: "name",
                            title: "Personalizado",
                            content: "Selecione se o provedor não está listado mas fornece os parâmetros necessários, incluindo recursos de portas Internet/IP-Phone/IPTV VLAN IDs e Prioridade, e LAN (1/2/3/4).",
                            children: [
                                {
                                    type: "name",
                                    title: "Internet/IP-Phone/ID VLAN IPTV/Prioridade",
                                    content: "Configure os IDs VLAN como fornecidas pelo provedor."
                                }, {
                                    type: "name",
                                    title: "Tag 802.11Q",
                                    content: "Selecione para marcar os pacotes de Internet com 802.11Q."
                                }, {
                                    type: "name",
                                    title: "ID VLAN Multicast IPTV/Prioridade",
                                    content: "Você pode ativar o recurso de multicast IPTV conforme desejado além de configurar o ID VLAN e Prioridade de acordo com o provedor."
                                }, {
                                    type: "name",
                                    title: "LAN 1/2/3/4",
                                    content: "Atribua uma porta LAN conforme necessidade do seu Provedor de Internet ou IPTV."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Proxy IGMP",
                    content: "Selecione a versão Proxy IGMP (Internet Group Management Protocol), sendo V2 ou V3, de acordo com seu provedor."
                }
            ]
        },
        DHCP_SERVER_SETTINGS: {
            TITLE: "Configurações",
            CONTENT: [
                {
                    type: "name",
                    title: "Servidor DHCP",
                    content: "Por padrão, o Servidor DHCP (Dynamic Host Configuration Protocol) é habilitado; ele atribui dinamicamente os parâmetros de TCP/IP para dispositivos clientes do pool de endereços IP. Não desative o servidor DHCP a menos que você tenha um outro servidor DHCP ou deseja atribuir manualmente os parâmetros de TCP/IP para cada dispositivo cliente em sua rede."
                }, {
                    type: "name",
                    title: "Pool de Endereço IP ",
                    content: "Digite o intervalo de endereços IP que podem ser concedidas aos clientes."
                }, {
                    type: "name",
                    title: "Período de Concessão de Endereço",
                    content: "Introduza a duração do tempo que um endereço IP é concedido para o cliente entre 2 e 2880 minutos. O padrão é de 120 minutos."
                }, {
                    type: "name",
                    title: "Gateway Padrão",
                    content: "Insira o endereço IP LAN. (Opcional)"
                }, {
                    type: "name",
                    title: "DNS Primário/DNS Secundário",
                    content: "Insira estes parâmetros conforme fornecidos pelo seu provedor. (Opcional)"
                }
            ]
        },
        RESERVED_IP_ADDRESS: {
            TITLE: "Reserva de Endereço",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Você pode reservar manualmente um endereço IP para um cliente que está conectado ao roteador. Uma vez reservado, o endereço IP será atribuído somente ao mesmo cliente pelo servidor DHCP."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Exibe o endereço MAC do cliente com  endereço IP de reserva DHCP."
                }, {
                    type: "name",
                    title: "Endereço IP Reservado",
                    content: "Mostra o endereço IP reservado do cliente."
                }, {
                    type: "name",
                    title: "Descrição",
                    content: "Exibe uma descrição do dispositivo cliente."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Exibe o status (habilitado ou desabilitado) do dispositivo cliente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Modificar ou Apagar o cliente correspondente."
                }, {
                    type: "step",
                    title: "Para reservar um endereço IP",
                    content: [
                        "1.Clique em Adicionar (Add).",
                        "2.Insira o endereço MAC do seu cliente desejado.",
                        "3.Insira o endereço IP que deseja reservar para o cliente.",
                        "4.Insira uma breve descrição para cliente.",
                        "5.Selecione Habilitar.",
                        "6.Clique em OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar ou apagar um cliente existente.",
                    content: "Na tabela, clique nos ícones Editar ou Apagar que correspondem aos clientes que você deseja modificar ou apagar."
                }
            ]
        },
        DHCP_CLIENT_LIST: {
            TITLE: "Lista de Cliente DHCP",
            CONTENT: [
                {
                    type: "name",
                    title: "Número do Cliente",
                    content: "Exibe o número de clientes DHCP associados."
                }, {
                    type: "name",
                    title: "Nome de Cliente",
                    content: "Exibe o nome do cliente DHCP."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Exibe o endereço MAC."
                }, {
                    type: "name",
                    title: "Endereço IP Atribuído",
                    content: "Exibe o endereço IP alocado ao cliente pelo servidor DHCP."
                }, {
                    type: "name",
                    title: "Tempo de Concessão",
                    content: "Exibe a duração do endereço IP que foi concedido ao cliente."
                }, {
                    type: "name",
                    title: "Atualizar",
                    content: "Clique para atualizar a Lista Cliente DHCP."
                }
            ]
        },
        DDNS: {
            TITLE: "DNS Dinâmico",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O DNS Dinâmico permite atribuir um host fixo e nome de domínio para um endereço IP de Internet dinâmico. É útil quando você estiver hospedando seu próprio website, servidor FTP, ou outro servidor através do Roteador. Primeiramente, você precisa se ​​inscrever em um provedor de serviço DDNS, como o www.dyndns.com."
                }, {
                    type: "step",
                    title: "Para configurar um DNS Dinâmico",
                    content: ["1. Selecione seu provedor de serviço DDNS.", "2. Digite o nome de usuário e senha da sua conta DDNS.", "3. Insira o Nome de Domínio que o provedor de serviço de DDNS ofereceu.", "4. Selecione seu Intervalo de Atualização da lista flutuante.", "5. Clique em Login e Salvar."]
                }, {
                    type: "paragraph",
                    content: "Para alternar entre contas, você deve primeiro Sair da conta atual e depois Entrar em outra conta com o novo nome de usuário e senha."
                }
            ]
        },
        ADVANCED_ROUTING_STATIC_ROUTING: {
            TITLE: "Roteamento Estático",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O Roteamento Avançado é usado para predeterminar uma rota fixa para os pacotes de informação de rede a fim de alcançar um host ou rede específica."
                }, {
                    type: "step",
                    title: "Para configurar um Roteamento Estático",
                    content: [
                        "1. Clique em Adicionar (Add).",
                        "2. Rede de Destino - Insira um endereço IP na linha hexadecimal para atribuir a rota estática para esta entrada.",
                        "3. Máscara de sub-rede - Digite uma máscara de sub-rede em formato hexadecimal para determinar a parte da rede e parte do host do endereço IP.",
                        "4. Gateway Padrão - Insira um endereço IP de gateway em formato hexadecimal para conectar o roteador à rede ou host.",
                        "5. Interface - Selecione LAN ou WAN para especificar o tipo de Rede de Destino.",
                        "6. Descrição - Insira uma breve descrição para esta entrada.",
                        "7. Selecione Habilitar.",
                        "8. Clique em OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar ou apagar uma entrada existente.",
                    content: "Na tabela, clique nos ícones Editar ou Apagar que correspondem às entradas que você deseja modificar ou apagar."
                }
            ]
        },
        ADVANCED_ROUTING_SYSTEM_ROUTING: {
            TITLE: "Tabela de Roteamento de Sistema",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Tabela de Roteamento do Sistema exibe todas as entradas de rota válidos que estão atualmente em uso."
                }, {
                    type: "paragraph",
                    content: "Clique em Atualizar para restaurar a tabela de Roteamento."
                }
            ]
        },
        WIRELESS_REGION: {
            TITLE: "Configurações",
            CONTENT: [
                {
                    type: "name",
                    title: "Região",
                    content: "Selecione a região no menu flutuante. Se o país ou região não estiver listado, ele pode ser restringido para usar o rádio wireless no local."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Salvar</b> para confirmar as alterações."
                }
            ]
        },
        WIRELESS_BOTH: {
            TITLE: "Wireless",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "As instruções abaixo são para <span class=\"anti_5g\">tanto 2.4GHz como 5GHz </span>redes wireless."
                }, {
                    type: "name",
                    title: "Habilitar Rádio Wireless",
                    content: "Selecione esta caixa para habilitar a frequência de rádio wireless."
                }, {
                    type: "name",
                    title: "Nome de Rede (SSID)",
                    content: "Você pode deixar o SSID padrão ou estabelecer um novo nome (até 32 caracteres). Este campo é também suscetível à letras maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Selecione esta opção se você deseja ocultar o SSID da lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Crie uma senha wireless entre 8 e 63 caracteres ASCII, ou entre  8 e 64 caracteres hexadecimais para proteger esta rede wireless."
                }, {
                    type: "name",
                    title: "Avançado",
                    content: "Clique para exibir mais configurações avançadas."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Selecione uma das seguintes opções de segurança:",
                    children: [
                        {
                            type: "name",
                            title: "Sem Segurança",
                            content: "Selecione esta opção para desabilitar a segurança wireless. É <b>altamente recomendável</b> que você ative a segurança wireless para proteger sua Rede para Convidados de acessos não-autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Pessoal",
                            content: "Selecione esta opção para ativar o método de autenticação padrão com base em uma chave pré -compartilhada (PSK), também chamada de senha. Esta opção é recomendada. Caso selecionado, configure o seguinte.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versão",
                                    content: "Selecione uma versão de segurança para sua rede wireless.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Esta opção suporta múltiplas implementações de padrões WPA (Wi-Fi Protected Access), como WPA e WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opção suporta criptografias TKIP e AES. "
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opção oferece um melhor nível de segurança do que WPA-PSK e é muito recomendada."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Criptografia",
                                    content: "Selecione um tipo de criptografia de segurança: <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard), ou <b>Auto</b> (para ambos padrões TKIP e AES). <b>NÃO</b> é recomendável utilizar a criptografia TKIP se o extensor de alcance powerline opera em modo 802.11ne, porque TKIP não é compatível com a especificação 802.11n."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Selecione esta opção para ativar método de autenticação básica se qualquer um dos dispositivos de cliente só pode acessar o usando WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Selecione um tipo de autenticação para a sua rede wireless. O padrão é <b>Auto</b>, que escolhe automaticamente <b>Abrir Sistema</b> ou <b>Chave Compartilhada</b> com base na capacidade e solicitação de acesso do cliente wireless."
                                }, {
                                    type: "name",
                                    title: "Chave Selecionada",
                                    content: "Selecione uma das quatro chaves."
                                }, {
                                    type: "name",
                                    title: "Formato de Chave WEP",
                                    content: "Utilize os formatos <b>ASCII</b> ou <b>Hexadecimal</b>. O formato ASCII é uma combinação de O formato hexadecimal é uma combinação de números (0-9) e letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Chave",
                                    content: "Selecione um tamanho de chave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Permite-lhe introduzir 10 dígitos hexadecimais (0-9, A-F, a-f) ou 5 caracteres ASCII no campo de senha."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Permite-lhe introduzir 26 dígitos hexadecimais (0-9, A-F, a-f) ou 13 caracteres ASCII no campo de senha."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Selecione um modo de transmissão misto."
                }, {
                    type: "name",
                    title: "Largura do Canal",
                    content: "Selecione uma largura de canal (largura de banda) para a rede wireless."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Selecione um canal de funcionamento da rede wireless correspondente. Recomenda-se a deixar o canal em <b>Auto</b>, se não estiver enfrentando problema de conexão wireless intermitente."
                }, {
                    type: "name",
                    title: "Poder de Transmissão",
                    content: "Selecione <b>Alto</b>, <b>Médio</b>, ou <b>Baixo</b> para especificar o poder de transmissão de dados. A configuração padrão e recomendada é <b>Alta</b>."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Salvar</b> para confirmar as alterações."
                }
            ]
        },
        WIRELESS_24G: {
            TITLE: "Wireless 2.4GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Rádio Wireless",
                    content: "Selecione esta caixa para habilitar a frequência de rádio wireless 2.4GHz."
                }, {
                    type: "name",
                    title: "Nome de Rede (SSID)",
                    content: "Você pode deixar o SSID padrão ou estabelecer um novo nome (até 32 caracteres). Este campo é também suscetível à letras maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Selecione esta opção se você deseja ocultar o nome de rede 2.4GHz (SSID) da lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Crie uma senha wireless entre 8 e 63 caracteres ASCII, ou entre  8 e 64 caracteres hexadecimais para proteger esta rede wireless."
                }, {
                    type: "name",
                    title: "Avançado",
                    content: "Clique para exibir mais configurações avançadas."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Selecione uma das seguintes opções de segurança:",
                    children: [
                        {
                            type: "name",
                            title: "Sem Segurança",
                            content: "Selecione esta opção para desabilitar a segurança wireless. É <b>altamente recomendável</b> que você ative a segurança wireless para proteger sua Rede para Convidados de acessos não-autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Pessoal",
                            content: "Selecione esta opção para ativar o método de autenticação padrão com base em uma chave pré -compartilhada (PSK), também chamada de senha. Esta opção é recomendada. Caso selecionado, configure o seguinte.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versão",
                                    content: "Selecione uma versão de segurança para sua rede wireless.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Esta opção suporta múltiplas implementações de padrões WPA (Wi-Fi Protected Access), como WPA e WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opção suporta criptografias TKIP e AES. "
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opção suporta criptografia AES que oferece um melhor nível de segurança do que WPA-PSK e é recomendável."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Criptografia",
                                    content: "Selecione um tipo de criptografia de segurança: <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard), ou <b>Auto</b> (para ambos padrões TKIP e AES). <b>NÃO</b> é recomendável utilizar a criptografia TKIP se o extensor de alcance powerline opera em modo 802.11ne, porque TKIP não é compatível com a especificação 802.11n."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Selecione esta opção para ativar método de autenticação básica se qualquer um dos dispositivos de cliente só pode acessar o usando WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Selecione um tipo de autenticação para a sua rede wireless. O padrão é <b>Auto</b>, que escolhe automaticamente <b>Abrir Sistema</b> ou <b>Chave Compartilhada</b> com base na capacidade e solicitação de acesso do cliente wireless."
                                }, {
                                    type: "name",
                                    title: "Chave Selecionada",
                                    content: "Selecione uma das quatro chaves."
                                }, {
                                    type: "name",
                                    title: "Formato de Chave WEP",
                                    content: "Utilize os formatos ASCII ou Hexadecimal. O formato ASCII é uma combinação de O formato hexadecimal é uma combinação de números (0-9) e letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Chave",
                                    content: "Selecione um tamanho de chave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Permite-lhe introduzir 10 dígitos hexadecimais (0-9, A-F, a-f) ou 5 caracteres ASCII no campo de senha."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Permite-lhe introduzir 26 dígitos hexadecimais (0-9, A-F, a-f) ou 13 caracteres ASCII no campo de senha."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Selecione um modo de transmissão misto."
                }, {
                    type: "name",
                    title: "Largura do Canal",
                    content: "Selecione uma largura de canal (largura de banda) para a rede wireless 2.4GHz."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Selecione um canal operacional para a rede wireless 2.4GHz. Recomenda-se a deixar o canal em <b>Auto</b>, se não estiver enfrentando problema de conexão wireless intermitente."
                }, {
                    type: "name",
                    title: "Poder de Transmissão",
                    content: "Selecione <b>Alto</b>, <b>Médio</b>, ou <b>Baixo</b> para especificar o poder de transmissão de dados. A configuração padrão e recomendada é <b>Alta</b>."
                }
            ]
        },
        WIRELESS_5G: {
            TITLE: "Wireless 5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Rádio Wireless",
                    content: "Selecione esta caixa para habilitar a frequência de rádio wireless 2.4GHz."
                }, {
                    type: "name",
                    title: "Nome de Rede (SSID)",
                    content: "Você pode deixar o SSID padrão ou estabelecer um novo nome (até 32 caracteres). Este campo é também suscetível à letras maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Selecione esta opção se você deseja ocultar o o nome de rede 5GHz (SSID) de convidados a partir da lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Crie uma senha wireless entre 8 e 63 caracteres ASCII, ou entre  8 e 64 caracteres hexadecimais para proteger esta rede wireless."
                }, {
                    type: "name",
                    title: "Avançado",
                    content: "Clique para exibir mais configurações avançadas."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Selecione uma das seguintes opções de segurança:",
                    children: [
                        {
                            type: "name",
                            title: "Sem Segurança",
                            content: "Selecione esta opção para desabilitar a segurança wireless. É <b>altamente recomendável</b> que você ative a segurança wireless para proteger sua Rede para Convidados de acessos não-autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2-Pessoal",
                            content: "Selecione esta opção para ativar o método de autenticação padrão com base em uma chave pré -compartilhada (PSK), também chamada de senha. Esta opção é recomendada. Caso selecionado, configure o seguinte.",
                            children: [
                                {
                                    type: "name",
                                    title: "Versão",
                                    content: "Selecione uma versão de segurança para sua rede wireless.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "Auto",
                                            content: "Esta opção suporta múltiplas implementações de padrões WPA (Wi-Fi Protected Access), como WPA e WPA2."
                                        }, {
                                            type: "name",
                                            title: "WPA-PSK",
                                            content: "Esta opção suporta criptografias TKIP e AES. "
                                        }, {
                                            type: "name",
                                            title: "WPA2-PSK",
                                            content: "Esta opção suporta criptografia AES que oferece um melhor nível de segurança do que WPA-PSK e é recomendável."
                                        }
                                    ]
                                }, {
                                    type: "name",
                                    title: "Criptografia",
                                    content: "Selecione um tipo de criptografia de segurança: <b>TKIP</b> (Temporal Key Integrity Protocol), <b>AES</b> (Advanced Encryption Standard), ou <b>Auto</b> (para ambos padrões TKIP e AES). <b>NÃO</b> é recomendável utilizar a criptografia TKIP se o extensor de alcance powerline opera em modo 802.11ne, porque TKIP não é compatível com a especificação 802.11n."
                                }
                            ]
                        }, {
                            type: "name",
                            title: "WEP",
                            content: "Selecione esta opção para ativar método de autenticação básica se qualquer um dos dispositivos de cliente só pode acessar o usando WEP (Wired Equivalent Privacy).",
                            children: [
                                {
                                    type: "name",
                                    title: "Tipo",
                                    content: "Selecione um tipo de autenticação para a sua rede wireless. O padrão é <b>Auto</b>, que escolhe automaticamente <b>Abrir Sistema</b> ou <b>Chave Compartilhada</b> com base na capacidade e solicitação de acesso do cliente wireless."
                                }, {
                                    type: "name",
                                    title: "Chave Selecionada",
                                    content: "Selecione uma das quatro chaves."
                                }, {
                                    type: "name",
                                    title: "Formato de Chave WEP",
                                    content: "Utilize os formatos <b>ASCII</b> ou <b>Hexadecimal</b>. O formato ASCII é uma combinação de O formato hexadecimal é uma combinação de números (0-9) e letras (A-F, a-f)."
                                }, {
                                    type: "name",
                                    title: "Tipo de Chave",
                                    content: "Selecione um tamanho de chave WEP.",
                                    children: [
                                        {
                                            type: "name",
                                            title: "64-bit",
                                            content: "Permite-lhe introduzir 10 dígitos hexadecimais (0-9, A-F, a-f) ou 5 caracteres ASCII no campo de senha."
                                        }, {
                                            type: "name",
                                            title: "128-bit",
                                            content: "Permite-lhe introduzir 26 dígitos hexadecimais (0-9, A-F, a-f) ou 13 caracteres ASCII no campo de senha."
                                        }
                                    ]
                                }
                            ]
                        }
                    ]
                }, {
                    type: "name",
                    title: "Modo",
                    content: "Selecione um modo de transmissão misto."
                }, {
                    type: "name",
                    title: "Largura do Canal",
                    content: "Selecione uma largura de canal (largura de banda) para a rede wireless 5GHz."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Selecione um canal de funcionamento da rede sem wireless 5GHz. Recomenda-se deixar o canal em Auto, se você não está enfrentando o problema de conexão wireless intermitente."
                }, {
                    type: "name",
                    title: "Poder de Transmissão",
                    content: "Selecione Alto, Médio ou Baixo para especificar os dados de transmissão de dados.  A configuração padrão e recomendada é Alta ."
                }, {
                    type: "paragraph",
                    content: "Clique em Salvar para confirmar as alterações."
                }
            ]
        },
        WIFI_TIME_CONTROL: {
            TITLE: "Agendamento Wi-Fi",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Os agendamentos Wi-Fi permitem que você defina horários específicos para ligar o Wi-Fi."
                }, {
                    type: "name",
                    title: "Agendamento Wi-Fi",
                    content: "Alterne para <b>Habilitar</b> e permitir o recurso de agendamento Wi-Fi. Caso queira que o Wi-Fi permaneça ligado enquanto os dispositivos wireless ainda estão conectados à rede wireless, selecione está opção."
                }
            ]
        },
        WIFI_CLONE: {
            TITLE: "Wi-Fi Clone",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O Wi-Fi Clone é usado para copiar as configurações wireless (incluindo SSID e senha wireless) do roteador wireless principal para o extensor."
                }, {
                    type: "name",
                    title: "Seleção de Banda Wi-Fi",
                    content: "Selecione um <span class=\"anti_5g\">ou ambos </span>a serem clonados.<span class=\"anti_5g\">Se o roteador principal permite clonar uma banda por vez, recomendamos que escolha 2.4GHz e 5GHz para garantir que a banda clonada seja consistente com a banda permitida pelo seu roteador.</span>"
                }
            ]
        },
        WIFI_TIME_GRID: {
            TITLE: "Agendamentos Wi-Fi (Desligar)",
            CONTENT: [
                {
                    type: "name",
                    title: "De",
                    content: "Mostra o momento em que o Wi -Fi é desligado."
                }, {
                    type: "name",
                    title: "Para",
                    content: " Mostra o horário em que o Wi-Fi é ligado novamente ."
                }, {
                    type: "name",
                    title: "Dia(s)",
                    content: "Mostra o(s) dia(s) efetivo(s) da agenda."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Indica se a entrada de agendamento está habilitada ou não. Clique no ícone Lâmpada para habilitar (ou desabilitar) o agendamento."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para <b>Modificar</b> ou <b>Apagar</b> a entrada correspondente."
                }, {
                    type: "step",
                    title: "Para adicionar uma nova agenda",
                    content: ["1. Clique em <b>Adicionar</b>.", "2. Especifique um intervalo de tempo no qual o Wi-Fi será desligado.", "3. Selecione o(s) dia(s).", "4. Selecione <b>Habilitar esta entrada</b>.", "5. Clique em <b>OK</b> para salvar esta entrada."]
                }, {
                    type: "paragraph",
                    content: "Para modificar ou apagar uma entrada, basta clicar no ícone <b>Editar</b> para alterar a informação ou na <b>Lixeira</b> para apagar a entrada correspondente."
                }, {
                    type: "paragraph",
                    content: "Para excluir várias agendas, selecione todos os horários e clique em <b>Apagar</b> acima da tabela."
                }
            ]
        },
        WPS: {
            TITLE: "PIN do Roteador",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Outros dispositivos podem se conectar a este roteador WPS com o PIN do roteador."
                }, {
                    type: "name",
                    title: "Habilitar PIN do Roteador",
                    content: "Alterne para On (Ligado) para permitir que dispositivos wireless se conectem ao roteador para se conectar ao roteador usando o PIN do roteador (Personal Identification Number)."
                }, {
                    type: "name",
                    title: "PIN do Roteador",
                    content: "Exibe o PIN do Roteador. O PIN padrão pode ser encontrado na etiqueta do roteador ou no Guia do Usuário. Clique em Gerar para gerar um novo PIN de forma aleatória ou clique em Padrão para restaurar o PIN atual para o PIN padrão de fábrica."
                }
            ]
        },
        WPS_WIZARD: {
            TITLE: "Assistente WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selecione um método de configuração"
                }, {
                    type: "name",
                    title: "Pressionar Botão (Recomendado)",
                    content: "Selecione este método de configuração para permitir a função WPS para conectar facilmente qualquer dispositivo compatível com esta função com a sua rede wireless através do botão WPS ou via virtual utilizando o botão conectar."
                }, {
                    type: "name",
                    title: "PIN",
                    content: "Selecione o método de configuração para adicionar um dispositivo manualmente inserindo o PIN WPS do dispositivo wireless no campo e clique em Conectar."
                }
            ]
        },
        WIRELESS_STATISTICS: {
            TITLE: "Clientes Wireless Online",
            CONTENT: [
                {
                    type: "name",
                    title: "Clientes Totais",
                    content: "Exibe o número total de clientes wireless conectados à rede powerline."
                }, {
                    type: "name",
                    title: "Nome do Dispositivo",
                    content: "Exibe o nome do cliente wireless."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Mostra o endereço IP do cliente wireless em uso."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Mostra o endereço MAC do cliente wireless."
                }, {
                    type: "name",
                    title: "Banda Wireless",
                    content: "Exibe a banda de frequência <span class=\"anti_5g\">(2.4GHz ou 5GHz) </span> da rede wireless na qual o cliente wireless está conectado."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Exibe o tipo segurança do cliente wireless."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Atualizar</b> para atualizar as informações nesta página."
                }
            ]
        },
        GUEST_NETWORK_BASIC: {
            TITLE: "Rede para Convidados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A <b>Rede para Convidados</b> permite configurar uma rede wireless em rede separada com um nome diferente (SSID) e a senha que seus convidados podem usar para acessar a Internet."
                }
            ]
        },
        GUEST_NETWORK_SETTINGS: {
            TITLE: "Rede para Convidados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A <b>Rede para Convidados</b> permite configurar uma rede wireless em rede separada com um nome diferente (SSID) e a senha que seus convidados podem usar para acessar a Internet."
                }, {
                    type: "name",
                    title: "Permitir convidados verem uns aos outros",
                    content: "Selecione esta opção para permitir que os dispositivos wireless na rede para convidados se comuniquem entre si."
                }, {
                    type: "name",
                    title: "Não permitir convidados a gerenciarem minha rede",
                    content: "Selecione esta opção para prevenir convidados de se logarem na interface de gerenciamento web."
                }, {
                    type: "name",
                    title: "Desabilitar automaticamente após",
                    content: "Selecione esta opção para desligar automaticamente a Rede para Convidados com base no tempo específico."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Salvar</b> para confirmar as alterações."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS: {
            TITLE: "Configurações de Rede para Convidados",
            CONTENT: [
                {
                    type: "name",
                    title: "2.4GHz | 5GHz",
                    content: "Alterne para 2.4GHz e 5GHz para exibir suas configurações."
                }, {
                    type: "name",
                    title: "Habilitar Rede para Convidados",
                    content: "Selecione esta caixa de seleção para habilitar a função de Rede para Convidados."
                }, {
                    type: "name",
                    title: "Nome de Rede (SSID)",
                    content: "Ou use o padrão SSID de Convidado ou crie um novo nome (até 32 caracteres)."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Selecione uma das seguintes opções de segurança:",
                    children: [
                        {
                            type: "name",
                            title: "Sem Segurança",
                            content: "Selecione esta opção para desabilitar a segurança wireless. É <u><b>altamente recomendável</b></u> que você ative a segurança wireless para proteger sua Rede para Convidados de acessos não-autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Pessoal",
                            content: "Selecione esta opção para ativar o método de autenticação padrão com base em uma chave pré -compartilhada (PSK), também chamada de senha. Caso selecionado, configure o seguinte."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Utilize a senha padrão ou crie uma senha entre 8 e 63 caracteres ASCII ou entre 8 e 64 caracteres hexadecimais (0-9, a-f, A- F)."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Salvar</b> para salvar suas configurações wireless de Rede para Convidados."
                }
            ]
        },
        GUEST_NETWORK_WIRELESS_2G: {
            TITLE: "Configurações de Rede para Convidados",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Rede para Convidados",
                    content: "Selecione esta caixa de seleção para habilitar a função de Rede para Convidados."
                }, {
                    type: "name",
                    title: "Nome de Rede (SSID)",
                    content: "Ou use o padrão SSID de Convidado ou crie um novo nome (até 32 caracteres)."
                }, {
                    type: "name",
                    title: "Segurança",
                    content: "Selecione uma das seguintes opções de segurança:",
                    children: [
                        {
                            type: "name",
                            title: "Sem Segurança",
                            content: "Selecione esta opção para desabilitar a segurança wireless. É <u><b>altamente recomendável</b></u> que você ative a segurança wireless para proteger sua Rede para Convidados de acessos não-autorizados."
                        }, {
                            type: "name",
                            title: "WPA/WPA2 - Pessoal",
                            content: "Selecione esta opção para ativar o método de autenticação padrão com base em uma chave pré -compartilhada (PSK), também chamada de senha. Caso selecionado, configure o seguinte."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Utilize a senha padrão ou crie uma senha entre 8 e 63 caracteres ASCII ou entre 8 e 64 caracteres hexadecimais (0-9, a-f, A- F)."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Salvar</b> para salvar suas configurações wireless de Rede para Convidados."
                }
            ]
        },
        NAT: {
            TITLE: "Gateway de Camada de Aplicação (ALG)",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "ALG (Gateway de Camada de Aplicação) permite filtros tranversais NAT a serem plugados no gateway a fim de serem compatíveis com tradução de endereço e porta para certos protocolos de camadas de aplicação \"control/data\": FTP, TFTP, H323 etc. Habilitar ALG é recomendável."
                }, {
                    type: "name",
                    title: "Habilitar FTP ALG",
                    content: "Se selecionada, permite clientes FTP (File Transfer Protocol) e servidores para transferir dados através de NAT."
                }, {
                    type: "name",
                    title: "Habilitar TFTP ALG",
                    content: "Se selecionada, permite clientes TFTP ( Trivial File Transfer Protocol ) e servidores para transferir dados através de NAT."
                }, {
                    type: "name",
                    title: "Habilitar H323 ALG",
                    content: "Se selecionado, ele permite que os clientes Microsoft NetMeeting para se comunicar via NAT."
                }, {
                    type: "name",
                    title: "Habilitar RTSP ALG",
                    content: "Se selecionado, ele permite que os clientes do media player para se comunicar com servidores de streaming de mídia via NAT."
                }, {
                    type: "name",
                    title: "Habilitar Passagem PPTP",
                    content: "Se selecionado, permite IPSec (Internet Protocol Security) a ser encapsulado através de uma rede IP passando pelo roteador."
                }, {
                    type: "name",
                    title: "Habilitar Passagem L2TP",
                    content: "Se selecionada, permite sessões ponto-a- ponto L2 a serem encapsulado através de uma rede IP e passando pelo roteador."
                }, {
                    type: "name",
                    title: "Habilitar Passagem IPSec",
                    content: "Se selecionada, permite IPSec (Internet Protocol Security) a ser encapsulado através de uma rede IP passando pelo roteador. IPSec utiliza serviços de segurança criptográficos para garantir comunicações privadas e seguras através de redes IP."
                }, {
                    type: "paragraph",
                    content: "Clique em Salvar para confirmar as alterações."
                }
            ]
        },
        VIRTUAL_SERVERS: {
            TITLE: "Servidores Virtuais",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Servidores virtuais são usadas para configurar serviços públicos em sua rede local. Um servidor virtual é definido como uma porta externa, e todas as solicitações da Internet para esta porta externa serão redirecionados para um computador definido, que deve ser configurado com um endereço IP estático ou reservado."
                }, {
                    type: "name",
                    title: "Tipo de Serviço",
                    content: "Exibe o nome do seu servidor virtual."
                }, {
                    type: "name",
                    title: "Porta Externa",
                    content: "Exibe o número da porta ou um intervalo de portas usadas pelo servidor virtual."
                }, {
                    type: "name",
                    title: "IP Interno",
                    content: "Exibe o número da porta do computador executando o aplicativo de serviço."
                }, {
                    type: "name",
                    title: "Porta Interna",
                    content: "Exibe o número da porta do computador executando o aplicativo de serviço."
                }, {
                    type: "name",
                    title: "Protocolo",
                    content: "Exibe o protocolo usado para o aplicativo de serviço: TCP, UDP ou Todos (Todos os protocolos suportados pelo roteador.)"
                }, {
                    type: "name",
                    title: "Status",
                    content: "Exibe o status atual (ativado ou desativado) da regra de filtragem específica."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Modificar ou Apagar a regra correspondente."
                }, {
                    type: "step",
                    title: "Para configurar uma regra de Serviço Virtual:",
                    content: ["1.Clique em Adicionar (Add).", "2. Clique em Visualizar Serviços Existentes para selecionar um serviço da lista para preencher automaticamente os números  adequados nos campos da porta externa e porta interna . Se o serviço não estiver listado, digite o número externo da porta (por exemplo 21) ou um intervalo de portas (por exemplo, 21-25). Deixe o espaço em branco da porta interna se é a mesma que a porta externa ou insira um número de porta específico (por exemplo 21) se a porta externa é uma única porta . Digite o endereço IP do computador que executa o aplicativo de serviço no formato decimal com pontos no campo IP interno .", "3.Selecione um protocolo para o aplicativo de serviço: TCP, UDP, ou Todos da lista drop-down de Protocolos.", "4.Selecione Habilitar.", "5.Clique em OK"]
                }, {
                    type: "step",
                    title: "Para modificar ou apagar uma regra de Servidor Virtual",
                    content: "Clique no ícone Modificar ou o ícone da Lixeira que corresponde à regra que você pretende modificar ou apagar ."
                }, {
                    type: "step",
                    title: "Para apagar regras múltiplas",
                    content: "Selecione todas as entradas que gostaria de apagar e clique em Apagar acima da tabela."
                }, {
                    type: "note",
                    title: "Aviso",
                    content: "Se o dispositivo host local está hospedando mais de um tipo de serviços disponíveis, você precisa criar uma regra para cada serviço."
                }
            ]
        },
        PORT_TRIGGERING: {
            TITLE: "Disparo de Porta",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O Disparo de Porta é utilizado para encaminhar o tráfego em uma determinada porta para o servidor específico na rede."
                }, {
                    type: "name",
                    title: "Aplicação",
                    content: "Exibe o nome do aplicativo."
                }, {
                    type: "name",
                    title: "Porta de Disparo",
                    content: "Exibe a porta de tráfego de saída utilizada para disparar uma regra de filtragem de uma conexão de saída."
                }, {
                    type: "name",
                    title: "Protocolo de Disparo",
                    content: "Exibe o protocolo utilizado para o Disparo de Porta. TCP, UDP ou Todos (Todos os protocolos suportados pelo roteador.)"
                }, {
                    type: "name",
                    title: "Porta Externa",
                    content: "Exibe o intervalo de porta a porta utilizada pelo sistema remoto. Uma resposta usando uma dessas portas será encaminhada para o PC que disparou esta regra. Você pode inserir no máximo 5 grupos de portas ( ou seções de portas) Cada grupo de portas devem ser separadas com \",\", por exemplo, 2000-2038, 2046, 2050-2051, 2085, 3010-3030."
                }, {
                    type: "name",
                    title: "Protocolo Externo",
                    content: "Exibe o protocolo utilizado para Porta de Entrada: TCP, UDP ou Todos (Todos os protocolos suportados pelo roteador)."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Exibe o status atual (ativado ou desativado) da regra de filtragem específica."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Modificar ou Apagar a regra correspondente."
                }, {
                    type: "step",
                    title: "Para configurar uma regra de Disparo de Porta",
                    content: [
                        {
                            type: "note",
                            title: "Aviso",
                            content: "Cada regra pode ser utilizada por um host de uma vez."
                        },
                        "1. Clique em Adicionar (Add).", {
                            content: "2. Clique em Visualizar Aplicações Existentes para selecionar uma aplicação da lista para preencher automaticamente os valores padrão nos campos apropriados. Se você quiser adicionar um aplicativo não listado, digite manualmente a Aplicação, Porta de Disparo, Protocolo de Disparo, Porta Externa e Protocolo Externo ",
                            children: [
                                {
                                    type: "note",
                                    title: "Aviso",
                                    content: "As regras não podem ter quaisquer intervalos de portas sobrepondo uns aos outros (por exemplo Regra 1 tem o intervalo de portas 4200-4205 , o que significa Regra 2 não pode ter intervalo de portas 4203-4206 )."
                                }
                            ]
                        },
                        "3. Selecione Habilitar.",
                        "4. Clique em OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar ou apagar uma regra de Disparo de Porta",
                    content: "Na tabela, clique no ícone Modificar ou no ícone da Lixeira que corresponde à regra que pretende modificar ou apagar."
                }, {
                    type: "step",
                    title: "Para apagar múltiplas regras de Disparo de Porta",
                    content: "Na tabela, selecione todas as regras que você deseja excluir, clique em Excluir acima da tabela."
                }
            ]
        },
        DMZ: {
            TITLE: "DMZ",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A função host DMZ (Zona Desmilitarizada) permite um host local a ser exposto à Internet para propósitos específicos como jogos online ou vídeo-conferência. Basicamente, o DMZ permite que um único computador na LAN abra todos as suas portas. Este computador tem de ser configurado com um endereço IP estático e tem a sua função de cliente DHCP desativada."
                }, {
                    type: "step",
                    title: "Para atribuir um computador ou servidor para serem um servidor DMZ",
                    content: ["1. Clique em habilitar DMZ.", "2. No campo Endereço IP Host DMZ, digite o endereço IP de um computador local para configurar como o host DMZ.", "3. Clique em Salvar."]
                }
            ]
        },
        UPNP: {
            TITLE: "UPnP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Por padrão, o recurso Universal Plug-and-Play (UPnP) é habilitado para permitir que dispositivos, como computadores e aparelhos de Internet, para descobrir e se comunicar uns com os outros na rede local automaticamente."
                }, {
                    type: "paragraph",
                    content: "A Lista de Serviço UPnP exibe as informações do dispositivo UPnP."
                }, {
                    type: "name",
                    title: "Descrição do Serviço",
                    content: "Exibe uma breve descrição do host local que inicia o pedido UPnP."
                }, {
                    type: "name",
                    title: "Porta Externa",
                    content: "Exibe a porta externa que é aberta pelo host local."
                }, {
                    type: "name",
                    title: "Protocolo",
                    content: "Mostra o tipo de protocolo de rede que é usado pelo host local."
                }, {
                    type: "name",
                    title: "Endereço IP Interno",
                    content: "Exibe o endereço IP do host local."
                }, {
                    type: "name",
                    title: "Porta Interna",
                    content: "Exibe a porta interna que é aberta pelo host local."
                }, {
                    type: "paragraph",
                    content: "Clique em Atualizar para atualizar a lista de Servidor UPnP."
                }
            ]
        },
        DISK_SETTING: {
            TITLE: "Configurações dos Dispositivos",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A página de Configurações do Dispositivo mostra as informações de qualquer dispositivo de armazenamento USB conectado através da porta USB. "
                }, {
                    type: "name",
                    title: "Buscar",
                    content: "Normalmente, o roteador detecta automaticamente qualquer dispositivo recém-anexado. Caso contrário, clique neste botão para procurar por algum dispositivo conectado recentemente e atualize a página com as novas informações."
                }, {
                    type: "name",
                    title: "Volume",
                    content: "Mostra o nome do volume USB."
                }, {
                    type: "name",
                    title: "Capacidade",
                    content: "Mostra a capacidade de armazenamento USB total."
                }, {
                    type: "name",
                    title: "Espaço Livre",
                    content: "Mostra o espaço livre disponível atual para armazenamento."
                }, {
                    type: "name",
                    title: "Remover com Segurança",
                    content: "Clique nesse botão para desmontar de forma segura o dispositivo de armazenamento USB antes de o desligar fisicamente do roteador ."
                }, {
                    type: "paragraph",
                    content: "Observe que o botão Remover com Segurança aparece somente quando há algum dispositivo USB de armazenamento conectado ao roteador, e você não poderá removê-lo enquanto o volume atual estiver ocupado."
                }, {
                    type: "name",
                    title: "Ativo",
                    content: "Esta tabela aparece somente quando há um dispositivo USB de armaznemanto conectado ao roteador. Selecione para habilitar o compartilhamento de arquivos do dispositivo USB."
                }, {
                    type: "step",
                    title: "Para configurar um servidor de arquivo.",
                    content: ["1. Conecte o dispositivo USB de armazenamento à porta do roteador utilizando um cabo USB.", "2. O dispositivo USB recém-anexado deve ser detectado automaticamente pelo roteador e exibida a informação sob a seção Configurações do dispositivo. Caso não, clique em Scan.", "3. Selecione Ativar para habilitar o compartilhamento de arquivo."]
                }
            ]
        },
        FOLDER_SHARE_ACCOUNT: {
            TITLE: "Conta para Compartilhamento",
            CONTENT: [
                {
                    type: "name",
                    title: "Conta",
                    content: "Você pode selecionar o uso de conta padrão para acessar os arquivos e pastas compartilhados ou Usar Nova Conta e digitar o seguinte para criar uma nova conta de usuário."
                }, {
                    type: "name",
                    title: "Nome de Usuário/Senha",
                    content: "Insira uma senha alfanumérica ou sob as linhas de até 15 caracteres. O nome de usuário deve iniciar com um caractere alfabético. Estes campos são sensíveis a letras mínusculas e maiúsculas."
                }, {
                    type: "name",
                    title: "Confirmar Senha",
                    content: "Insira novamente a senha para confirmar se não há algum erro de digitação. Este campo é também suscetível à letras maiúsculas e minúsculas."
                }, {
                    type: "paragraph",
                    content: "Clique em Salvar para confirmar sua conta de novo usuário."
                }
            ]
        },
        FOLDER_SHARE_SETTINGS: {
            TITLE: "Configurações de Compartilhamento",
            CONTENT: [
                {
                    type: "name",
                    title: "Rede/Nome de Servidor de Mídia",
                    content: "Mostra o nome utilizado para acessar o dispositivo de armazenamento USB conectado."
                }, {
                    type: "name",
                    title: "Habilitar",
                    content: "Selecione para habilitar o método de acesso."
                }, {
                    type: "name",
                    title: "Método de Acesso",
                    content: "Há três métodos de acesso para permitir ao dispositivo de compartilhamento USB. Você pode escolher um ou mais métodos selecionando a checkbox correspondente.",
                    children: [
                        {
                            type: "name",
                            title: "Ambiente de Rede",
                            content: "Caso habilitado, usuários na sua rede poderão acessar o dispositivo de armazenamento USB utilizando um endereço IP atribuído (ex.: \\\\192.168.0.1). Este método é habilitado por padrão."
                        }, {
                            type: "name",
                            title: "FTP",
                            content: "Caso habilitado, os clientes FTP na sua rede local poderão acessar o dispositivo de armazenamento USB utilizando o endereço IP atribuído, seguido do número de porta do servidor FTP (ex.://192.168.0.1:21)."
                        }, {
                            type: "name",
                            title: "FTP (Via Internet)",
                            content: "Se ativado, os usuários podem acessar remotamente a unidade de armazenamento USB através de FTP através da Internet. Esta função suporta tanto downloads como uploads de arquivos. Para alterar o número de porta do servidor FTP, insira um número de porta e clique em Salvar para aplicar as alterações."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Link",
                    content: "Exibe o endereço utilizado para acessar o dispositivo de compartilhamento USB compartilhado."
                }, {
                    type: "name",
                    title: "Porta",
                    content: "Exibe o número de porta do servidor FTP."
                }
            ]
        },
        FOLDER_SHARE_FOLDERS: {
            TITLE: "Compartilhamento de Pasta",
            CONTENT: [
                {
                    type: "name",
                    title: "Compartilhar Todos",
                    content: "Alterne para On para compartilhar todos os arquivos e pastas ou Off mpara compartilhar somente as pastas selecionadas."
                }, {
                    type: "name",
                    title: "Habilitar Autenticação",
                    content: "É recomendável habilitar autenticação para solicitar aos usuários a inserirem um nome de usuário e senha válidos para acessar as pastas de compartilhamente."
                }, {
                    type: "name",
                    title: "Nome da Pasta",
                    content: "Mostra o nome da Pasta de Compartilhamento"
                }, {
                    type: "name",
                    title: "Caminho da Pasta",
                    content: "Exibe o caminho para a pasta compartilhada."
                }, {
                    type: "name",
                    title: "Compartilhamento de Mídia",
                    content: "Indica se a pasta de compartilhamento tem permissão para compartilhamento de mídia ou não."
                }, {
                    type: "name",
                    title: "Nome do Volume",
                    content: "Mostra o nome da Pasta de Compartilhamento"
                }, {
                    type: "name",
                    title: "Status",
                    content: "Exibe o status da pasta compartilhada através do indicador lâmpada. Verde (Aceso) significa habilitado e verde (Apagado) significa desabilitado. Você pode habilitar ou desabilitar o compartilhamento clicando na lâmpada."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Modificar ou Apagar a pasta de compartilhamento correspondente."
                }, {
                    type: "name",
                    title: "Buscar",
                    content: "Clique para procurar por uma pasta de compartilhamento."
                }, {
                    type: "name",
                    title: "Permitir Acesso à Rede para Convidados",
                    content: "Selecione permitir clientes na Rede para Convidados para acessar pastas de compartilhamentos."
                }, {
                    type: "name",
                    title: "Habilitar Autenticação",
                    content: "Selecione para solicitar usuários a acessarem as pastas compartilhadas com um nome de usuário e senha válidos."
                }, {
                    type: "name",
                    title: "Habilitar Permissão Editar",
                    content: "Selecione para permitir usuários a fazerem alterações no conteúdo da pasta."
                }, {
                    type: "name",
                    title: "Habilitar Compartilhamento de Mídia.",
                    content: "Selecione para habilitar compartilhamento de mídia."
                }
            ]
        },
        PRINT_SERVER: {
            TITLE: "Servidor de Impressora",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar um Servidor de Impressão que pode ser utilizado através da sua rede.",
                    content: ["1. Conecte a impressora USB à porta USB do roteador através de um cabo USB.", "2. Instale o driver da impressora no seu computador. Consulte os manuais do fabricante do computador para obter instruções.", "3. Instale o Utilitário de Controlador de Impressora USB TP-Link, a partir do CD de recursos (somente para Windows) ou baixe-o (para Windows e Mac OS X) no site oficial da TP-Link."]
                }
            ]
        },
        PARENTAL_CONTROL: {
            TITLE: "Controle dos Pais",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Com os Controles dos Pais, você pode definir limites de tempo para dispositivos wireless e controlar quando estes dispositivos podem acessar a Internet."
                }, {
                    type: "name",
                    title: "Controle dos Pais",
                    content: "Alterne para <b>On</b> (Habilitado) para habilitar a função de Controle dos Pais."
                }
            ]
        },
        PARENTAL_CONTROL_DEVICES: {
            TITLE: "Dispositivos Sob Controle dos Pais",
            CONTENT: [
                {
                    type: "name",
                    title: "ID",
                    content: "Exibe o ID do dispositivo cliente."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Mostra o endereço MAC do dispositivo cliente."
                }, {
                    type: "name",
                    title: "Período de Acesso à Internet",
                    content: "Exibe os períodos de tempo de acesso permitidos."
                }, {
                    type: "name",
                    title: "Descrição",
                    content: "Exibe uma breve descriçãodo dispositivo conectado."
                }, {
                    type: "name",
                    title: "Status",
                    content: " Indica se o Controle dos Pais está ou não ativado para o dispositivo correspondente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para <b>Modificar</b> ou <b>Apagar</b> o serviço correspondente."
                }, {
                    type: "step",
                    title: "Para configurar um período limite",
                    content: [
                        "1. Clique em <b>Adicionar</b>.",
                        "2. Clique em <b>Visualizar Dispositivos Existentes</b> e escolha um dispositivo conectado em <b>Dispositivo de Acesso Wireless</b> Lista; ou em <b>Endereço MAC</b> manualmente para adicionar um dispositivo que não está ligado.",
                        "3. Clique em <b>Tempo de Acesso à Internet</b> para especificar o intervalo de tempo em que o dispositivo é permitido para acessar a Internet.",
                        "4. Insira uma breve descrição no campo <b>Descrição</b>. Este campo é opcional.",
                        "5. Selecione <b>Habilitar esta Entrada</b>.",
                        "6. Clique em <b>OK</b> para salvar esta entrada."
                    ]
                }, {
                    type: "paragraph",
                    content: "Para modificar ou apagar uma entrada da lista, clique no ícone <b>Editar</b> ou na <b>Lixeira</b> para apagar a entrada correspondente."
                }, {
                    type: "paragraph",
                    content: "Para excluir vários dispositivos da lista, selecione a opção correspondente dos dispositivos a serem excluídos e clique em <b>Apagar</b> acima da tabela."
                }
            ]
        },
        PARENTAL_CONTROL_RESTRICTION: {
            TITLE: "Restrição de Conteúdo",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista de Bloqueados",
                    content: "Contém palavras-chave que serão utilizadas para bloquear o acesso de dispositivos clientes especificados na lista de Controle dos Pais.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Clique em Adicionar uma Nova Palavra Chave para adicionar à Lista de Bloqueados. para apagar uma palavra-chave, clique no ícone (-) correspondente para apagar."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Lista de Permitidos",
                    content: "Contém endereços de websites que dispositivos clientes especificados na lista de Controle dos Pais são autorizados ao acesso.",
                    children: [
                        {
                            type: "paragraph",
                            content: "Clique em Adicionar um Novo Domínio para adicionar um website à Lista de Permitidos. Para apagar um website, clique no ícone (-) correspondente para apagar."
                        }
                    ]
                }, {
                    type: "note",
                    title: "Aviso",
                    content: "Palavras-chave também podem ser nomes de domínio, por exemplo, www.mail.google.com ou www.facebook.com."
                }, {
                    type: "paragraph",
                    content: "Clique em Salvar para fixar sua configuração."
                }
            ]
        },
        QOS: {
            TITLE: "QoS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O QoS (Qualidade de Serviço) ajuda a priorizar o tráfego da Internet baseando-se nas suas necessidades. Você pode especificar o nível de prioridade para um dispositivo ou uma aplicação na lista de regra QoS."
                }, {
                    type: "note",
                    title: "Aviso",
                    content: "Se a função NAT Boost for habilitada, o QoS deve ser desabilitada."
                }, {
                    type: "name",
                    title: "Habilitar QoS",
                    content: "Selecione esta caixa para habilitar a função QoS."
                }, {
                    type: "name",
                    title: "Largura de Banda de Upload",
                    content: "Insira a largura de banda máxima para upload fornecido pelo seu provedor."
                }, {
                    type: "name",
                    title: "Largura de Banda para Download",
                    content: "Insira a largura de banda máxima para download fornecidos pelo seu provedor."
                }, {
                    type: "name",
                    title: "Prioridade de Garantia Alta",
                    content: "Especifique uma porcentagem para o tráfego de alta prioridade."
                }, {
                    type: "name",
                    title: "Prioridade de Garantia Média",
                    content: "Especifique uma porcentagem para o tráfego de média prioridade."
                }, {
                    type: "name",
                    title: "Prioridade de Garantia Baixa",
                    content: "Especifique uma porcentagem para o tráfego de baixa prioridade."
                }, {
                    type: "note",
                    title: "Aviso",
                    content: "A quantidade (porcentagem) de todas as prioridade deve ser 1."
                }, {
                    type: "paragraph",
                    content: "Clique em Salvar para confirmar as alterações."
                }
            ]
        },
        QOS_RULE: {
            TITLE: "Lista de Regras QoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Tipo",
                    content: "Selecione um tipo para adicionar à lista de regras QoS."
                }, {
                    type: "step",
                    title: "Para estabelecer uma regra de alta/média/baixa prioridade Pelo Dispositivo.",
                    content: ["1. Clique em Adicionar (Add).", "2. Selecionado Pelo Dispositivo.", "3. Clique em Visualizar Dispositivos Existentes para selecionar seu dispositivo desejado da Lista de Dispositivos de Acesso, ou você pode inserir um  nome de dispositivo e seu endereço MAC manualmente nos campos Nome de Dispositivo e Endereço MAC.", "4. Clique em OK."]
                }, {
                    type: "step",
                    title: "Para estabelecer uma regra de alta/média/baixa prioridade Por Aplicação.",
                    content: ["1. Clique em Adicionar (Add).", "2. Selecione Por Aplicação. ", "3. Selecione o aplicativo desejado na lista de aplicativos, ou você pode personalizar uma aplicação configurando o nome, protocolo e porta nos campos correspondentes.", "4. Clique em OK."]
                }, {
                    type: "step",
                    title: "Para estabelecer uma regra de alta/média/baixa prioridade Pela Porta Física.",
                    content: ["1. Clique em Adicionar (Add).", "2. Selecione Por Porta Física.", "3. Selecione sua porta desejada.", "4. Clique em OK."]
                }
            ]
        },
        QOS_DATABASE: {
            TITLE: "Atualizar Base de Dados",
            CONTENT: [
                {
                    type: "name",
                    title: "Novo Arquivo de Base de Dados",
                    content: "Clique em Procurar para localizar seu arquivo de nova base de dados. Selecione-o e clique em Atualizar para obter base de dados mais recente."
                }, {
                    type: "name",
                    title: "Versão de Base de Dados",
                    content: "Exibe a versão atual de database."
                }
            ]
        },
        SECURITY_FIREWALL: {
            TITLE: "Firewall",
            CONTENT: [
                {
                    type: "name",
                    title: "SPI Firewall",
                    content: "A função SPI (Stateful Packet Inspection) Firewall impede ataques cibernéticos e valida o tráfego que está passando através do roteador baseado no protocolo. A função SPI Firewall é habilitada por padrão de fábrica. "
                }
            ]
        },
        SECURITY_DOS: {
            TITLE: "Proteção DoS",
            CONTENT: [
                {
                    type: "name",
                    title: "Proteção DoS",
                    content: "A Proteção DoS (Denial of Service) protege a LAN contra ataques DoS de flooding em sua rede com solicitações ao servidor. Por padrão, a Proteção DoS é desabilitada (Off)."
                }, {
                    type: "name",
                    title: "Filtragem de Ataque ICMP-FLOOD",
                    content: "Habilite para prevenir ataque ICMP-flood (Internet Control Message Protocol)		 "
                }, {
                    type: "name",
                    title: "Filtragem de Ataque UDP-FLOOD",
                    content: "Habilite para previnir o ataque flood de protocolo UDP."
                }, {
                    type: "name",
                    title: "Filtragem de Ataque TCP-SYN-FLOOD",
                    content: "Habilite para prevenir ataques TCP-SYN-FLOOD (Control Protocol-Synchronize).",
                    children: [
                        {
                            type: "name",
                            title: "Desligado",
                            content: "Sem proteção."
                        }, {
                            type: "name",
                            title: "Baixa",
                            content: "Proteção de baixo nível e baixo impacto no desempenho do roteador."
                        }, {
                            type: "name",
                            title: "Média",
                            content: "Nível moderado de proteção e impacto quase notável no desempenho do roteador."
                        }, {
                            type: "name",
                            title: "Alta",
                            content: "Nível alto de proteção e impacto notável no desempenho do roteador."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ignorar Pacotes de Ping da Porta WAN",
                    content: "Habilite para ignorar pacotes de ping da porta WAN."
                }, {
                    type: "name",
                    title: "Proibir Pacotes de Ping da porta LAN",
                    content: "Habilite para proibir pacotes de ping da porta LAN."
                }
            ]
        },
        MAC_FILTER_ALL: {
            TITLE: "Filtragem de MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A Filtragem de MAC é utilizada para permitir ou bloquear computadores específicos e outros dispositivos de acessarem a sua rede. Quando um dispositivo é bloqueado, ele não pode conectar ao dispositivo powerline."
                }, {
                    type: "name",
                    title: "Configurações de Filtragem de MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtragem de MAC",
                            content: "Altere para <b>On</b> (Habilitar) para acionar esta função. Caso a função estiver desabilitada (Off), todos os dispositivos estão permitidos a conectar."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Selecione a regra de filtragem",
                    content: "Selecione para bloquear ou permitir que dispositivos clientes incluídos na lista de dispositivos possam acessar a rede wireless. Clique em <b>Salvar</b> para confirmar as alterações."
                }, {
                    type: "name",
                    title: "Lista de Dispositivos",
                    children: [
                        {
                            type: "step",
                            title: "Para adicionar um dispositivo cliente"
                        }, {
                            type: "step",
                            title: "Para modificar ou apagar um dispositivo cliente",
                            content: "Click em <b>Editar</b> ou em <b>Lixeira</b> que correspondam ao dispositivo que deseja modificar ou apagar."
                        }, {
                            type: "step",
                            title: "Para apagar múltiplos dispositivos na Lista de Dispositivos",
                            content: "Selecione a caixa correspondente ao dispositivo a ser apagado, e clique em <b>Apagar</b> acima da tabela."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER: {
            TITLE: "Filtragem de MAC",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A Filtragem de MAC é utilizada para permitir ou bloquear computadores específicos e outros dispositivos de acessarem a sua rede. Quando um dispositivo é bloqueado, ele não pode conectar ao dispositivo powerline."
                }, {
                    type: "name",
                    title: "Configurações de Filtragem de MAC",
                    children: [
                        {
                            type: "name",
                            title: "Filtragem de MAC",
                            content: "Altere para <b>On</b> (Habilitar) para acionar esta função. Caso a função estiver desabilitada (Off), todos os dispositivos estão permitidos a conectar."
                        }
                    ]
                }
            ]
        },
        MAC_FILTER_RULES: {
            TITLE: "Selecione a regra de filtragem",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selecione para bloquear ou permitir que dispositivos clientes incluídos na lista de dispositivos possam acessar a rede wireless."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Salvar</b> para confirmar as alterações."
                }
            ]
        },
        MAC_FILTER_DEVICE_LIST: {
            TITLE: "Lista de Dispositivos",
            CONTENT: [
                {
                    type: "step",
                    title: "Para adicionar um dispositivo cliente",
                    content: ["1. Clique em <b>Adicionar</b>.", "2. Clique em <b>Visualizar Dispositivos</b> e escolha o endereço MAC do dispositivo da lista ou insira o endereço MAC manualmente.", "3. Dê uma breve descrição sobre o dispositivo.", "4. Selecione <b>Habilitar esta entrada</b>.", "5. Clique em <b>OK</b>."]
                }, {
                    type: "step",
                    title: "Para modificar ou apagar um dispositivo na Lista de Dispositivos",
                    content: "Click em <b>Editar</b> ou em <b>Lixeira</b> que correspondam ao dispositivo que deseja modificar ou apagar."
                }, {
                    type: "step",
                    title: "Para apagar múltiplos dispositivos na Lista de Dispositivos",
                    content: "Selecione a caixa correspondente ao dispositivo a ser apagado, e clique em <b>Apagar</b> acima da tabela."
                }
            ]
        },
        WIFI_MOVE: {
            TITLE: "Wi-Fi Move",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Com o recurso Wi-Fi Move habilitado, todas as alterações feitas nas configurações Wi-Fi de um extensor de alcance powerline irá sincronizar automaticamente para outros extensores através da rede eléctrica na mesma rede powerline cujo recurso Move Wi-Fi também estiver habilitado. Note que se o nome padrão de fábrica, ou seja, HomePlugAV, estiver sendo usado, o recurso Move Wi-Fi será desativado automaticamente."
                }, {
                    type: "name",
                    title: "Wi-Fi Move",
                    content: "Altere para <b>On</b> (Habilitar) para acionar esta função."
                }
            ]
        },
        SECURITY_LIST: {
            TITLE: "Lista Host de DoS Bloqueados",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista Host de DoS Bloqueados",
                    content: "Lista os endereços IP e MAC de qualquer fonte de ataque DoS bloqueada."
                }, {
                    type: "step",
                    title: "Para apagar uma entrada",
                    content: "Na lista de Host, selecione uma entrada que gostaria de apagar e clique em Apagar acima da tabela."
                }
            ]
        },
        ACCESS_CONTROL: {
            TITLE: "Controle de Acesso",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O Controle de Acesso é utilizado para permitir ou bloquear outros dispositivos de acessarem a sua rede. Quando um dispositivo é bloqueado, ele pode obter um endereço IP do roteador, mas fica incapaz de se comunicar com outros dispositivos ou conectar-se à Internet."
                }, {
                    type: "paragraph",
                    content: "Para Utilizar o controle de Acesso, habilite a função para especificar a lista de bloqueados e permitidos. Caso o Controle de Acesso esteja desabilitado *(Off), todos os dispositivos, incluindo os da lista de bloqueados serão permitidos a conectar."
                }
            ]
        },
        ACCESS_MODE: {
            TITLE: "Modo de Acesso",
            CONTENT: [
                {
                    type: "name",
                    title: "Lista de Bloqueados",
                    content: "Somento dispositivos na Lista de Bloqueados serão bloqueados a acessarem sua rede."
                }, {
                    type: "name",
                    title: "Lista de Permitidos",
                    content: "Somento dispositivo na Lista de Permitidos serão permitidos a acessarem sua rede."
                }
            ]
        },
        ACCESS_DEVICE: {
            TITLE: "Dispositivos Online",
            CONTENT: [
                {
                    type: "name",
                    title: "Nome do Dispositivo",
                    content: "Mostra o nome do dispositivo conectado."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Mostra o endereço IP dispositivo conectado."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Mostra o endereço  MAC do dipositivo conectado."
                }, {
                    type: "name",
                    title: "Teste de Conexão",
                    content: "Mostra o tipo de conexão do dispositivo conectado."
                }, {
                    type: "step",
                    title: "Para bloquear um dispositivo",
                    content: "Na tabela de dispositivos on-line, clique no ícone Bloquear na coluna Modificar que corresponde ao dispositivo que você deseja bloquear."
                }, {
                    type: "step",
                    title: "Para bloquear múltiplos dispositivos",
                    content: "Na tabela de Dispositivos Online, selecione todos os dipositivos que deseja bloquear, clique em Bloquear acima da tabela. O dispositivo será automaticamente adicionado os Dispositivos na Lista de Bloqueados ou Permitidos."
                }
            ]
        },
        ACCESS_LIST: {
            TITLE: "Dispositivos na Lista de Bloqueados/Permitidos",
            CONTENT: [
                {
                    type: "step",
                    title: "Para bloquear ou permitir um dispositivo",
                    content: ["1. Clique no ícone Adicionar.", "2. Insira o Nome do Dispositivo.", "3. Insira o endereço MAC do dispositivo.", "4.  Clique em OK."]
                }, {
                    type: "step",
                    title: "Para modificar ou apagar um dispositivo na Lista de Permitidos/Bloqueados",
                    content: "Na tabela de Permitidos/Bloqueados, clique no ícone Editar ou na Lixeira que corresponde ao dispositivos que você deseja para modificar ou apagar."
                }, {
                    type: "step",
                    title: "Para apagar mútiplos dispositivos na Lista de Permitidos/Bloqueados",
                    content: "Na Lista de Permitidos/Bloqueados, selecione todos os dispositivos que você deseja apagar, clique em Apagar abaixo da tabela."
                }
            ]
        },
        IPMAC_BIND_SETTING: {
            TITLE: "Configurações",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O vínculo ARP (Address Resolution Protocol) é útil para controle de acesso de um específico computador na LAN ao vincular o endereço IP e o endereço MAC dos dois dispositivos. O vínculo ARP também previne outros dispositivos utilizando um endereço IP específico."
                }
            ]
        },
        IPMAC_BIND_ARP: {
            TITLE: "Lista ARP",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Mostra os endereços MAC e IP dos dispositivos conectados atualmente."
                }, {
                    type: "name",
                    title: "Número de Entrada ARP",
                    content: "Mostro o número total de dispositivos que estão atualmente conectados ao roteador."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Mostra o endereço  MAC do dipositivo conectado."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Exibe o endereço IP separado para o dispositivo conectado."
                }, {
                    type: "name",
                    title: "Vínculo",
                    content: "Indica se os endereços MAC ou IP estão vinculados ou não."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Mostra opções para Vincular ou Apagar a entrada correspondente da lista."
                }, {
                    type: "note",
                    title: "Aviso",
                    content: "Você não pode vincular o mesmo endereço IP para mais que um endereço MAC."
                }
            ]
        },
        IPMAC_BIND_LIST: {
            TITLE: "Lista de Vínculos",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar um dispositivo com vínculo ARP",
                    content: [
                        "1. Clique em Adicionar (Add).",
                        "2. Insira o endereço MAC do dispositivo.",
                        "3. Insira um endereço IP que você queira vincular ao endereço MAC acima",
                        "4. Insira uma Descrição para este dispositivo. (Opcional)",
                        "5. Selecione Habilitar.",
                        "6. Clique em OK."
                    ]
                }, {
                    type: "step",
                    title: "Para modificar ou apagar uma entrada",
                    content: "Na lista de vínculo, clique no ícone Modificar ou o ícone Excluir que corresponde à entrada que você deseja modificar ou apagar."
                }, {
                    type: "step",
                    title: "Para apagar entradas múltiplas",
                    content: "Na lista de vínculo, selecione todas as entradas que gostaria de apagar e clique em Apagar acima da tabela."
                }
            ]
        },
        IPV6: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "IPv6",
                    content: "Selecione habilitar (On) ou desabilitar (Off) a função IPv6 do roteador."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: IP Estático"
                }, {
                    type: "name",
                    title: "IP Estático",
                    content: "Selecione este tipo caso seu provedor utiliza atribuição de endereõ IPv6 Estático."
                }, {
                    type: "name",
                    title: "Endereço IPv6/Gateway Padrão/DNS Primário/DNS Secundário",
                    content: "Insira estes parâmetros conforme fornecidos pelo seu provedor."
                }, {
                    type: "name",
                    title: "Tamanho MTU",
                    content: "O padrão e tamanho MTU típico (Maximum Transmission Unit) para a maioria das redes Ethernet é de 1500 bytes. Não é recomendado alterar o tamanho padrão MTU a menos que seja exigido pelo provedor."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: IP Dinâmico"
                }, {
                    type: "name",
                    title: "IP Dinâmico",
                    content: "Selecione este tipo se o provedor utiliza a atribuição dinâmica de endereços IPv6."
                }, {
                    type: "name",
                    title: "Endereço IPv6/DNS Primário/DNS Secundário",
                    content: "Estes parâmetros são automaticamente atribuídos pelo servidor DHCPv6 do seu provedor."
                }, {
                    type: "name",
                    title: "Renovar",
                    content: "Clique neste botão para obter novos parâmetros IPv6 do servidor DHCPv6 do provedor."
                }, {
                    type: "name",
                    title: "Liberar",
                    content: "Clique para liberar todos os endereços IPv6 atribuídos pelo servidor DHCPv6 do provedor."
                }, {
                    type: "name",
                    title: "Obter Endereço IPv6",
                    content: "Selecione \"Obter endereço IPv6 não temporário\" ou \"Obter delegação de prefixo IPv6\", de acordo com seu provedor. "
                }, {
                    type: "name",
                    title: "Endereço DNS",
                    content: "Selecione \"Obter dinamicamente do provedor\" ou \"Utilizar o endereço DNS seguinte\". Caso \"Utilizar o Endereço DNS seguinte\" seja selecionado, favor inserir o endereço DNS manualmente oferecido pelo seu provedor."
                }, {
                    type: "name",
                    title: "DNS Primário/DNS Secundário",
                    content: "Insira estes parâmetros manualmente ou  obtenha-os dinamicamente do provedor."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: PPPoE"
                }, {
                    type: "name",
                    title: "PPPoE",
                    content: "Selecione este tipo caso seu provedor utilize PPPoEv6, e ofereça um nome de usuário e senha."
                }, {
                    type: "name",
                    title: "Nome de Usuário/Senha",
                    content: "Insira estes parâmetros conforme fornecidos pelo seu provedor."
                }, {
                    type: "name",
                    title: "Endereço IPv6",
                    content: "Este endereço será automaticamente atribuído pelo servidor DHCPv6 do provedor, depois que você inserir o nome de usuário e senha e clicar em Conectar. "
                }, {
                    type: "name",
                    title: "Endereço DNS",
                    content: "Selecione \"Obter dinamicamente do provedor\" ou \"Utilizar o endereço DNS seguinte\". Caso \"Utilizar o Endereço DNS seguinte\" seja selecionado, favor inserir o endereço DNS manualmente oferecido pelo seu provedor."
                }, {
                    type: "name",
                    title: "Obter Endereço IPv6",
                    content: "Selecione \"Não Temporário\" ou \"Prefixo de Delegação\" ou \"Especificado pelo Provedor\" de acordo com seu provedor. Caso selecionar \"Especificado pelo Provedor\", você deve inserir manualmente o endereço IPv6 conforme oferecido pelo seu provedor. Se você selecionar \"não temporária\" ou \"prefixo de delegação\", o endereço IPv6 será atribuído automaticamente pelo servidor DHCPv6 do provedor.",
                    children: [
                        {
                            type: "name",
                            title: "Não Temporário",
                            content: "Obtenha um endereço IPv6 não temporária pelo Servidor DHCPv6 a partir do provedor de serviços de Internet."
                        }, {
                            type: "name",
                            title: "Delegação de Prefixo",
                            content: "Obtenha um prefixo de delegação de endereços IPv6 pelo Servidor DHCPv6  a partir do provedor, e o cliente na LAN cria um endereço IPv6 com a delegação."
                        }, {
                            type: "name",
                            title: "Especificado pelo provedor.",
                            content: "Utilize endereço IPv6 estático especificado pelo provedor."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Conectar",
                    content: "Clique neste botão para conectar à Internet."
                }, {
                    type: "name",
                    title: "Desconectar",
                    content: "Clique neste botão para desconectar da Internet."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: Túnel 6para4"
                }, {
                    type: "name",
                    title: "Túnel 6para4",
                    content: "Selecione este tipo caso seu provedor utilize implementação 6para4 para atribuição de endereços."
                }, {
                    type: "name",
                    title: "Endereço IPv4/Máscara de Sub-rede IPv4/Gateway IPv4 Padrão/Endereço de Túnel",
                    content: "Estes parâmetros serão dinamicamente gerados através de parâmetros IPv4 da porta WAN após você clicar em Conectar."
                }, {
                    type: "name",
                    title: "Utilize o servidor DNS seguinte",
                    content: "Selecione esta caixa de seleção para habilitar esta opção. E insira então o DNS primário/secundário fornecido pelo seu provedor."
                }, {
                    type: "name",
                    title: "Conectar",
                    content: "Clique neste botão para conectar à Internet."
                }, {
                    type: "name",
                    title: "Desconectar",
                    content: "Clique neste botão para desconectar da Internet."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: 6RD"
                }, {
                    type: "name",
                    title: "6RD",
                    content: "Selecione este tipo caso seu provedor utilize implementação 6RD e ofereça um endereço IPv4 e prefixos de endereços IPv6."
                }, {
                    type: "name",
                    title: "Tipo de Configuração",
                    content: "Selecione Automático ou Manual para configurar os parâmetros do canal 6RD de acordo com seu provedor. Caso os parâmetros padrões abaixo coincidam com os fornecidos pelo provedor, você pode selecionar Automático; caso contrário, selecione Manual e insira os parâmaetros de acordo com os fornecidos pelo seu provedor."
                }, {
                    type: "name",
                    title: "Tamanho de Máscara IPv4/Prefixo 6RD/Tamanho de Prefixo 6RD/Endereço IPv4 Border Relay",
                    content: "Verifique se os parâmetros predefinidos coincidem com aqueles fornecidos por seu provedor, e mantê-lo em padrão ou inserí-los manualmente conforme fornecido pelo seu provedor."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: DS-Lite"
                }, {
                    type: "name",
                    title: "DS-Lite",
                    content: "Selecione este tipo se o seu provedor utiliza implantação DS-Lite, e oferece-lhe um nome de domínio AFTR ou endereço IPv6, para a criação de um túnel IPv4-em-IPv6 na rede IPv6 para comunicar tráfegos IPv4 ou IPv6 tráfegos em sua respectiva rede."
                }, {
                    type: "name",
                    title: "Nome AFTR",
                    content: "AFTR é a abreviação de Endereço Familiar de Roteador de Transição.  Neste campo, insira o nome de domínio AFTR ou endereço IPv6 como fornecido pelo seu provedor."
                }, {
                    type: "name",
                    title: "Conexão Secundária",
                    content: "Selecione a conexão secundária de acordo com o fornecido pelo seu provedor.",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinâmico",
                            content: "Selecione se o seu provedor fornece-lhe um IP dinâmico como um tipo de conexão secundária e os parâmetros IPv6 Address/DNS primário/DNS secundário serão atribuídos automaticamente pelo servidor DHCPv6 do provedor."
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: "Selecione este tipo caso seu provedor utiliza atribuição de endereõ IPv6 Estático."
                        }, {
                            type: "name",
                            title: "PPPoE",
                            content: "Selecione se o seu provedor lhe fornece PPPoE como o tipo de conexão secundária e digite o nome de usuário/senha fornecidos pelo seu provedor. O endereço IPv6 será automaticamente atribuído após você clicar em Conectar."
                        }
                    ]
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: Passagem (Bridge)"
                }, {
                    type: "paragraph",
                    content: "Selecione este tipo caso o provedor utiliza implementação de rede Pass-Through (Bridge). Para este tipo, nenhum parâmetro é fornecido e nenhuma configuração é necessária."
                }
            ]
        },
        IPV6_LAN: {
            TITLE: "LAN",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exceto para Pass Through (Bridge), os outros 6 tipos de conexão com a Internet requerem configurações para os parâmetros IPv4 LAN ao mesmo tempo."
                }, {
                    type: "name",
                    title: "Tipo Atribuído",
                    content: "Escolha o mais adequado de acordo com o provedor.",
                    children: [
                        {
                            type: "name",
                            title: "DHCPv6",
                            content: "Para automaticamente atribuir endereços IP aos clientes na LAN.",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefixo de Endereço",
                                    content: "Digite o prefixo do endereço fornecidos pelo provedor."
                                }, {
                                    type: "name",
                                    title: "Tempo de Concessão",
                                    content: "Significa o tempo em que o endereço IP atribuído permanecerá válido. Ou mantenha o padrão 86400 segundos ou altere-o, se exigido pelo provedor."
                                }, {
                                    type: "name",
                                    title: "Endereço",
                                    content: "É o endereço IP atribuído automaticamente pelo servidor DHCPv6 do provedor."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC+DHCP Sem Estado",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefixo de Endereço",
                                    content: "Digite o prefixo do endereço fornecidos pelo provedor."
                                }, {
                                    type: "name",
                                    title: "Endereço",
                                    content: "É o endereço IP atribuído automaticamente pelo servidor DHCPv6 do provedor."
                                }
                            ]
                        }, {
                            type: "name",
                            connector: " ",
                            title: "SLAAC+RDNSS",
                            children: [
                                {
                                    type: "name",
                                    title: "Prefixo de Endereço",
                                    content: "Digite o prefixo do endereço fornecidos pelo provedor."
                                }, {
                                    type: "name",
                                    title: "Endereço",
                                    content: "É o endereço IP atribuído automaticamente pelo servidor DHCPv6 do provedor."
                                }
                            ]
                        }
                    ]
                }
            ]
        },
        IPV6_MAC_CLONE: {
            TITLE: "Clone de Mac",
            CONTENT: [
                {
                    type: "name",
                    title: "Utilizar Endereço MAC Padrão",
                    content: "NÃO altere o endereço MAC padrão do roteador, caso o provedor não vincula o endereço IP atribuído ao endereço MAC."
                }, {
                    type: "name",
                    title: "Utilizar Endereço MAC do Computador Atual",
                    content: "Selecione para copiar o endereço MAC atual do computador que está conectado ao roteador, caso o provedor vincule o endereço IP atribuído para o endereço do computador MAC."
                }, {
                    type: "name",
                    title: "Utilizar Endereço MAC Personalizado",
                    content: "Digite o endereço MAC manualmente, caso o provedor vincule o endereço IP atribuído ao endereço MAC específico."
                }
            ]
        },
        TIME_SETTING: {
            TITLE: "Ajuste de Horário",
            CONTENT: [
                {
                    type: "step",
                    title: "Para sincronizar o horário automaticamente",
                    content: ["1. Selecione seu <b>Fuso Horário</b> na lista flutuante.", "2. No campo <b>Servidor NTP I</b>, insirra o endereço IP do seu servidor NTP desejado. (Opcional)", "3. No campo <b>Servidor NTP II</b>, insirra o endereço IP do seu servidor NTP desejado. (Opcional)", "4. Clique em <b>Obter GMT</b>."]
                }, {
                    type: "step",
                    title: "Para configurar",
                    content: ["1. No campo <b>Configurações de Horário</b>, selecione seu <b>Fuso Horário.</b> local.", "2. Insira a <b>Data</b> atual.", "3. Selecione o <b>Horário</b> atual (em formato 24h, exemplo, 16h00 são 04h00 pm).", "4. Clique <b>Salvar</b>."]
                }
            ]
        },
        TIME_SETTING_DAYLIGHT: {
            TITLE: "Horário de Verão",
            CONTENT: [
                {
                    type: "step",
                    title: "Para configurar o Horário de Verão.",
                    content: ["1. Selecione <b>Habilitar Horário de Verão</b>.", "2. Selecione a data e hora <b>Inicial</b> correta de quando o horário de verão começa em seu fuso horário local.", "3. Selecione a data e hora <b>Final</b> correta de quando o horário de verão se encerra no seu horário local.", "4. Clique <b>Salvar</b>."]
                }
            ]
        },
        DIGNOSTIC: {
            TITLE: "Diagnósticos",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O roteador fornece ferramentas de ping e traceroute para ajudar a solucionar problemas de conectividade de rede. A ferramenta Ping envia pacotes para um endereço IP de destino ou nome de domínio e registra os resultados, tais como o número de pacotes enviados/recebidos, e o tempo de ida e volta. A ferramenta Traceroute envia pacotes para um endereço IP de destino ou nome de domínio e exibe o número de saltos e tempo para chegar ao destino."
                }, {
                    type: "paragraph",
                    content: "Você pode fazer ping e traceroute em um dispositivo local pelo endereço IP ou um nome de domínio, como google.com, yahoo.com, etc."
                }, {
                    type: "step",
                    title: "Para diagnosticar uso Ping",
                    content: ["1. Favor inserir o endereço IP alvo ou Nome de Domínio.", "2. Clique no Ícone Seta para abrir o menu Avançado e especificar a Contagem Ping, e o Tamanho do Pacote Ping. (Opcional)", "3. Clique em Start (Iniciar)."]
                }, {
                    type: "step",
                    title: "Para diagnosticar utilizando Traceroute",
                    content: ["1. Favor inserir o endereço IP alvo ou Nome de Domínio.", "2. Clique no Ícone Seta para abrir o menu Avançado e especificar o número de saltos (a ser atingido) no campo Traceroute Max TTL (Time to Live). O padrão é 20. (Opcional)", "3. Clique em Start (Iniciar)."]
                }
            ]
        },
        FIRMWARE: {
            TITLE: "Atualização de Firmware",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Antes de atualizar o firmware do extensor de alcance powerline, você precisará baixar a atualização de firmware mais recente de <a class=\"link\" href=\"http://www.tp-link.com/br/support/\" target=\"_blank\">TP-Link Support</a> para o seu computador."
                }, {
                    type: "step",
                    title: "IMPORTANTE: Para prevenir falha ao atualizar, favor atentar-se aos seguintes detalhes:",
                    content: ["Verifique se o arquivo de firmware mais recente está compatível com a versão do hardware (como mostrado na página de Atualização de Firmware). ", "Certifique-se de que você tem uma conexão estável entre o extensor de alcance powerline e o computador. NÃO é recomendável atualizar o firmware via wireless.", "Faça backup da configuração de seu extensor de alcance powerline.", "NÃO desligue a energia durante a atualização."]
                }, {
                    type: "step",
                    title: "Para atualizar a firmware do extensor de alcance powerline",
                    content: ["1. Clique em <b>Localizar</b>.", "2. Localize e selecion o arquivo de firmware baixado.", "3. Clique em <b>Atualizar</b>."]
                }, {
                    type: "paragraph",
                    content: "A atualização de firmware leva alguns minutos para se completar. Favor NÃO desligar o extensor de alcance powerline durante o processo de atualização."
                }
            ]
        },
        FIRMWARE_UPGRADE_ONLINE: {
            TITLE: "Para atualizar a firmware online",
            CONTENT: [
                {
                    type: "paragraph",
                    content: ["Clique em Atualizar e clique em Sim quando solicitado, em seguida o extensor irá baixar o firmware mais recente automaticamente e atualizar. Você também pode clicar em Verificar para buscar  versões mais recentes."]
                }
            ]
        },
        FIRMWARE_UPGRADE: {
            TITLE: "Para atualizar manualmente o firmware",
            CONTENT: [
                {
                    type: "step",
                    content: ["1. Clique em Suporte na parte inferior da página e baixar o firmware mais recente para o computador . Por favor, certifique-se de que a versão do firmware que você está baixando seja compatível com a versão do hardware do roteador como mostrado na página.", "2. Clique em Procurar (Browse) para localizar e selecionar o arquivo de firmware baixado.", "3. Clique em Upgrade."]
                }, {
                    type: "paragraph",
                    content: ["A atualização de firmware leva alguns minutos. O extensor irá reiniciar automaticamente quando a atualização se encerrar."]
                }
            ]
        },
        BACKUP: {
            TITLE: "Fazer Backup",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "É altamente recomendável fazer backup de suas configurações atuais no caso de uma recuperação para restaurar o sistema para um estado anterior ou a partir dos padrões de fábrica."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Backup</b> para salvar suas configurações atuais em seu computador. Garanta que tenha salvo o arquivo em local seguro e que você possa recuperá-lo e restaurar o extensor posteriormente se necessário."
                }
            ]
        },
        RESTORE: {
            TITLE: "Restaurar",
            CONTENT: [
                {
                    type: "step",
                    title: "Para restaurar a partir de backup",
                    content: ["1. Clique em <b>Localizar</b>.", "2. Localize e selecione o arquivo backup.", "3. Clique em <b>Restaurar</b>."]
                }
            ]
        },
        FACTORY: {
            TITLE: "Restaurar Padrões de Fábrica",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Clique em <b>Restauração de Fábrica</b> para restaurar seu extensor de alcance powerline às suas configurações de fábrica."
                }, {
                    type: "note",
                    title: "Aviso",
                    content: ["1. A Restauração de Fábrica irá apagar todas as configurações feitas no extensor. Para fazer o login na página de gerenciamento novamente, utilize o padrão  <b>admin</b> para nome de usuário e senha.", "2. Favor NÃO desligar o extensor durante o processo de backup ou restauração."]
                }
            ]
        },
        ADMIN_ACCOUNT: {
            TITLE: "Gerenciamento de Conta",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Esta página permite que você altere seu login de nome de usuário e senha."
                }, {
                    type: "name",
                    title: "Nome de Usuário Antigo",
                    content: "Digite seu nome de usuário atual."
                }, {
                    type: "name",
                    title: "Senha Antiga",
                    content: "Digite sua senha atual."
                }, {
                    type: "name",
                    title: "Novo Nome de Usuário",
                    content: "Digite seu novo nome de usuário."
                }, {
                    type: "name",
                    title: "Nova Senha",
                    content: "Digite sua nova senha."
                }, {
                    type: "name",
                    title: "Confirmar a Nova Senha",
                    content: "Digite sua nova senha novamente."
                }, {
                    type: "note",
                    title: "Aviso",
                    content: "Se você alterar o nome de usuário e senha atuais usados ​​para fazer login no extensor de alcance powerline, certifique-se de que a nova informação de login está anotada em um local seguro. Uma senha forte deve ter pelo menos 8 ou mais caracteres de comprimento, combinando letras maiúsculas e minúsculas, números e sinais de pontuação."
                }, {
                    type: "paragraph",
                    content: "Clique em <b>Salvar</b> para confirmar as alterações."
                }
            ]
        },
        ADMIN_RECOVERY: {
            TITLE: "Senha de Recuperação",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Senha de Recuperação",
                    content: "É altamente recomendável que você habilite o recurso de recuperação de senha, que irá enviar o seu nome de usuário e senha perdida ou esquecida por e-mail."
                }, {
                    type: "name",
                    title: "De",
                    content: "Digite o endereço de email válido para ser usado para e-mails enviados."
                }, {
                    type: "name",
                    title: "Para",
                    content: "Digite o endereço de email válido para ser usado para e-mails recebidos."
                }, {
                    type: "name",
                    title: "Servidor SMTP",
                    content: "Digite o endereço do servidor SMTP que o roteador usa para enviar as informações de conta via e-mail."
                }, {
                    type: "name",
                    title: "Habilitar Autenticação",
                    content: "Selecione Habilitar Autenticação se o servidor de e-mail de saída requer autenticação para o envio de e-mail como também preencher o Nome de Usuário e Senha nos campos correspondentes. Estes campos são sensíveis a letras mínusculas e maiúsculas."
                }
            ]
        },
        ADMIN_LOCAL: {
            TITLE: "Gerenciamento Local",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Esta seção permite-lhe limitar o número de dispositivos clientes em sua LAN de acessar o roteador usando a autenticação baseada em endereço MAC."
                }, {
                    type: "name",
                    title: "Acesso para Todos os Dispositivos Conectados à LAN",
                    content: "Alternar para On (ligado) para permitir gerenciamento local para dispositivos LAN conectados ou Off (desligado) para permitir o gerenciamento de um dispositivo específico. "
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Mostra o endereço MAC do dispositivo de acesso limitado."
                }, {
                    type: "name",
                    title: "Descrição",
                    content: "Mostra a descrição do dispositivo de acesso limitado."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Mostra o status do dispositivo de acesso limitado (habilitado e desabilitado)."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Modificar ou Apagar o dispositivo correspondente da lista."
                }, {
                    type: "step",
                    title: "Para adicionar um dispositivo cliente à lista",
                    content: ["1. Clique em Adicionar (Add).", "2. Clique em Visualizar dispositivos existentes para escolher um dispositivo existente ou digite o endereço MAC de um dispositivo no campo Endereço MAC.", "3. Insira uma Descrição para o dispositivo. (Opcional)", "4. Selecione Habilitar.", "5. Clique em OK."]
                }, {
                    type: "step",
                    title: "Para modificar ou apagar um dispositivo na lista",
                    content: "Clique no ícone Modificar ou no ícone Excluir que corresponde ao dispositivo que você deseja modificar ou apagar."
                }, {
                    type: "step",
                    title: "Para apagar entradas múltiplas",
                    content: "Selecione todos os dispositivos que você deseja excluir, clique em Apagar."
                }
            ]
        },
        ADMIN_REMOTE: {
            TITLE: "Gerenciamento Remoto",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O recurso de gerenciamento remoto permite acessar e configurar o roteador remotamente da Internet."
                }, {
                    type: "name",
                    title: "Desabilitar Gerenciamento Remoto",
                    content: "Selecione esta opção para desativar o gerenciamento remoto."
                }, {
                    type: "name",
                    title: "Habilitar Gerenciamento Remoto para Todos os Dispositivos",
                    content: "Selecione esta opção para habilitar o gerenciamento remoto para todos os endereços IP. Se selecionado, inserir no campo Porta de Gerenciamento Web."
                }, {
                    type: "name",
                    title: "Habilitar Gerenciamento Remoto para um Dispositivos Específicos",
                    content: "Selecione esta opção para habilitar o gerenciamento remoto para um endereço IP específico. Caso selecionado, insira os campos de Porta de Gerenciamento Web e Endereço IP de Gerenciamento Remoto."
                }, {
                    type: "name",
                    title: "Porta de Gerenciamento Web",
                    content: "Digite o número da porta, insira entre 1024 e 65535, que é usado para acessar a interface de gerenciamento web do roteador com maior segurança. Normalmente, os navegadores da web usam a porta do serviço HTTP padrão 80. A porta de serviço padrão e comum é 8080, que é uma porta de serviço alternativa do HTTP."
                }, {
                    type: "name",
                    title: "Endereço IP de Gerenciamento Remoto",
                    content: "Insira um endereço IP válido ou um intervalo de IP para ser autorizado a acessar o roteador. Se 255.255.255.255 é inserido, todos estão autorizados a acessar."
                }
            ]
        },
        SYSTEM_LOG: {
            TITLE: "Sistema Log",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A página de log do sistema exibe uma lista das atividades mais recentes (eventos) do extensor. Você pode definir que tipos de registos e/ou o nível de logs que você deseja visualizar."
                }, {
                    type: "name",
                    title: "Tipo",
                    content: "Selecione o tipo de log do sistema para exibir."
                }, {
                    type: "name",
                    title: "Nível",
                    content: "Selecione o nível de log do sistema para exibir."
                }, {
                    type: "name",
                    title: "Atualizar",
                    content: "Clique neste ícone para atualizar o log do sistema."
                }, {
                    type: "name",
                    title: "Apagar Tudo",
                    content: "Clique neste ícone para excluir todos os logs do sistema."
                }, {
                    type: "name",
                    title: "Salvar Log",
                    content: "Clique nesse botão para baixar o arquivo de log do sistema para o seu computador local."
                }
            ]
        },
        TRAFFIC_STATISTIC: {
            TITLE: "Estatísticas de Tráfego",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A página de Estatísticas de Tráfego exibe o tráfego de rede da LAN, WAN e WLAN e o envio e recebimento de pacotes"
                }, {
                    type: "note",
                    title: "Aviso",
                    content: "Se a função NAT Boost for habilitada, as Estatísticas de Tráfego devem ser desabilitadas."
                }, {
                    type: "name",
                    title: "Estatísticas de Tráfego",
                    content: "Por padrão, a função Estatísticas de Tráfico está Desabilitada. Para exibir a informação de estatística, clique em Habilitar."
                }
            ]
        },
        TRAFFIC_STATISTIC_LIST: {
            TITLE: "Lista de Estatísticas de Tráfego",
            CONTENT: [
                {
                    type: "name",
                    title: "Endereço IP/Endereço MAC",
                    content: "Exibe o endereço IP e o endereço MAC do dispositivo cliente associado."
                }, {
                    type: "name",
                    title: "Pacotes Totais",
                    content: "Exibe o número total de pacotes transmitidos e recebidos pelo dispositivo cliente, desde o início da sessão ou desde quando o contador foi zerado."
                }, {
                    type: "name",
                    title: "Bytes Totais",
                    content: "Exibe o número total de bytes transmitidos e recebidos pelo dispositivo cliente, desde o início da sessão ou desde quando o contador foi zerado."
                }, {
                    type: "name",
                    title: "Pacotes Atuais",
                    content: "Exibe o número total de pacotes transmitidos e recebidos em um intervalo de tempo específico."
                }, {
                    type: "name",
                    title: "Bytes Atuais",
                    content: "Exibe o número atual de bytes transmitidos e recebidos em um intervalo de tempo específico."
                }, {
                    type: "name",
                    title: "ICMP Tx Atual",
                    content: "Exibe a taxa de transmissão atual e a taxa máxima de transmissão de pacotes ICMP transmitidos através da porta WAN por segundo."
                }, {
                    type: "name",
                    title: "UDP Tx Atual",
                    content: "Exibe a taxa de transmissão atual e a taxa máxima de transmissão de pacotes UDP transmitidos através da porta WAN por segundo."
                }, {
                    type: "name",
                    title: "SYN Tx Atual",
                    content: "Exibe a taxa de transmissão atual e a taxa máxima de transmissão de pacotes TCP SYN transmitidos através da porta WAN por segundo."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Retaurar (a zero) e Apagar a estatística correspondente da lista."
                }, {
                    type: "name",
                    title: "Atualizar",
                    content: "Clique para atualizar a informação estatística sobre a página."
                }, {
                    type: "name",
                    title: "Reiniciar Tudo",
                    content: "Clique para restaurar todos os valores estatísticos na lista para zero."
                }, {
                    type: "name",
                    title: "Apagar Tudo",
                    content: "Clique para apagar todas as informações estatísticas na lista."
                }
            ]
        },
        SYSTEM_PARA_WIRELESS: {
            TITLE: "Wireless 2.4GHz/5GHz",
            CONTENT: [
                {
                    type: "name",
                    title: "Intervalo Beacon",
                    content: "Insira um valor entre 40 e 1000 em milissegundos para determinar a duração entre pacotes beacon que são transmitidos pelo roteador para sincronizar a rede wireless. O padrão é 100 milisegundos."
                }, {
                    type: "name",
                    title: "RTS Threshold",
                    content: "Insira um valor entre 1 e 2346 para determinar o tamanho do pacote de transmissão de dados através do roteador. Por padrão, o tamanho Threshold RTS (Request to Send) é de 2.346 . Se o tamanho do pacote é maior do que o limite predeterminado, o roteador envia um pedido de envio de quadros a uma estação receptora e negocia o envio de uma frame de dados, ou então o pacote será enviado imediatamente."
                }, {
                    type: "name",
                    title: "Intervalo DTIM",
                    content: "Este valor determina o intervalo de DTIM (Mensagem de Indicação de Tráfego de Entrega). Por favor insira um valor de tempo limite de ping entre 1 e 15 milissegundos. O intervalo padrão é 1, indicando que o intervalo DTIM é o mesmo que o Intervalo Beacon."
                }, {
                    type: "name",
                    title: "Período de Atualização de Chave de Grupo",
                    content: "Digite o número de segundos (mínimo de 30) para controlar o intervalo de tempo para a chave de criptografia para renovação automática. O padrão é 0, indicando que não há renovação de chave."
                }, {
                    type: "name",
                    title: "Função WMM",
                    content: "A função WMM garante os pacotes de mensagens com alta prioridade a serem transmitidos preferencialmente. É habilitado por padrão e altamente recomendado."
                }, {
                    type: "name",
                    title: "Função Short GI",
                    content: "Esta função está habilitado por padrão e recomendada para aumentar a capacidade de pacotes pelo período GI (Intervalo de Guarda)."
                }, {
                    type: "name",
                    title: "Função Isolação AP",
                    content: "Por padrão, esta função é desabilitada. Se você quiser limitar e restringir todos os dispositivos wireless conectados à rede de interagir uns com os outros, mas que ainda sejam capazes de acessar a Internet, selecione a opção Ativar Isolamento AP."
                }, {
                    type: "name",
                    title: "Ponteamento WDS ",
                    content: "Habilite o recurso Bridging WDS (Wireless Distribution System) para permitir que o roteador se conecte com outro ponto de acesso (AP) em uma rede de área local wireless (WLAN). Se esta função está habilitada, configure conforme a seguir:",
                    children: [
                        {
                            type: "name",
                            title: "SSID",
                            content: "Digite o SSID do WAP (Wireless Access Point) que o roteador irá se conectar como um cliente ou usar o recurso de pesquisa para encontrar todas as redes disponíveis no canal atual."
                        }, {
                            type: "name",
                            title: "Pesquisa",
                            content: "Clique nesse botão para buscar e exibir o SSID, BSSID, força do sinal, canal e informações de segurança todas as redes wireless disponíveis dentro do intervalo. Depois de selecionar uma rede, o SSID, Endereço MAC e Segurança serão preenchidos automaticamente ."
                        }, {
                            type: "name",
                            title: "Endereço MAC (a ser ponteado)",
                            content: "Digite o endereço MAC (BSSID) em 12 caracteres hexadecimais (0-9, a- f, A-F) separados por hífens do access point wireless que irá conectar-se como um cliente. Se você escolher o AP desejado através do recurso de Pesquisa, o campo Endereço MAC é automaticamente preenchido ."
                        }, {
                            type: "name",
                            title: "Segurança",
                            content: "Selecione o tipo de segurança correto do acess point selecionado, Nº e se possuem padrão WPA-PSK/WPA2 -PSK ou WEP. Se você escolher o AP desejado através do recurso de Pesquisa, o campo de Segurança é preenchido automaticamente.",
                            children: [
                                {
                                    type: "name",
                                    title: "Senha",
                                    content: "Esta opção é disponível quando o tipo de seguranaça é WPA-PSK/WPA2-PSK ou WEP. Digite a senha do ponto de acesso selecionado a segurança ."
                                }, {
                                    type: "name",
                                    title: "Autent. Tipo",
                                    content: "Esta opção só está disponível quando o tipo de segurança é WEP (Wired Equivalent Privacy). Selecione o tipo de autenticação adequado (Auto, Open System ou Shared Key) utilizado pelo access point selecionado."
                                }, {
                                    type: "name",
                                    title: "Formato de Chave WEP",
                                    content: "Esta opção só é disponível quando o tipo de seguranaça é WEP. Selecione o formato de chave (ASCII ou Hexadecimal) usado para o AP selecionado."
                                }
                            ]
                        }
                    ]
                }, {
                    type: "paragraph",
                    content: "Clique em Salvar para confirmar as alterações."
                }
            ]
        },
        SYSTEM_PARA_WPS: {
            TITLE: "WPS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selecione a opção Ativar WPS e clique em Salvar para habilitar as WPS (Wi -Fi Protected Setup ) função que permite configurar de forma fácil e conectar os dispositivos WPS habilitados pressionando um botão ."
                }
            ]
        },
        SYSTEM_PARA_NAT: {
            TITLE: "NAT",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Selecione a opção Ativar NAT e clique em Salvar para habilitar a função NAT (Network Address Translation)."
                }, {
                    type: "name",
                    title: "NAT Boost",
                    content: "Selecione a opção Ativar NAT Boost e clique em Salvar para garantir que o roteador tenha a melhor taxa de transferência."
                }, {
                    type: "note",
                    title: "Aviso",
                    content: "A função NAT Boost será desativada quando QoS ou estatísticas de tráfego estiverem habilitados."
                }
            ]
        },
        SYSTEM_PARA_DOS: {
            TITLE: "Configurações de Nível de Proteção DOS",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "O Nível de Proteção DoS protege o roteador de ataques TCP- SYN- Flood, UDP- Flood, além de ataques ICMP-flood. "
                }, {
                    type: "name",
                    title: "Nível de Pacotes ICMP-FLOOD",
                    content: "Insira um valor entre 5 e 7200 para acionar a proteção ICMP-FLOOD imediatamente quando o número de pacotes excederem o valor threshold limite predefinido."
                }, {
                    type: "name",
                    title: "Nível de Pacotes UDP-FLOOD",
                    content: "Insira um valor entre 5 e 7200 pacotes UDP para acionar a proteção UDP-FLOOD imediatamente quando o número de pacotes exceder o valor limiar predefinido."
                }, {
                    type: "name",
                    title: "Nível de Pacotes TCP-FLOOD",
                    content: "Insira um valor entre 5 e 7200 pacotes TCP- SYN para desencadear a proteção TCP- SYN- FLOOD imediatamente quando o número de pacotes exceder o valor limiar."
                }, {
                    type: "paragraph",
                    content: "Clique em Salvar para confirmar as alterações."
                }
            ]
        },
        SYSTEM_PARA_DUPLEX: {
            TITLE: "Duplex",
            CONTENT: [
                {
                    type: "name",
                    title: "Duplex",
                    content: "Selecione o tipo duplex a partir da lista flutuante."
                }, {
                    type: "paragraph",
                    content: "Clique em Salvar para confirmar as alterações."
                }
            ]
        },
        BASIC_NETWORK_INTEREST: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Status da Internet",
                    content: "Mostra o status da conexão de Internet do roteador."
                }, {
                    type: "name",
                    title: "Teste de Conexão",
                    content: "Mostra o tipo de conexão de Internet"
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Exibe o endereço IP de Internet atual atribuído ao roteador."
                }, {
                    type: "name",
                    title: "Conexão Secundária/Endereço IP",
                    content: "Mostra o tipo de conexão secundária e o endereço IP."
                }
            ]
        },
        BASIC_NETWORK_ROUTER: {
            TITLE: "Roteador",
            CONTENT: [
                {
                    type: "title",
                    title: "Wireless 2.4GHz/5GHz"
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Exibe o nome da rede wireless atual da frequência de banda de 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Canal",
                    content: "Mostra o canal em que a rede wireless de 2.4GHz/5GHz transmite."
                }, {
                    type: "name",
                    title: "MAC",
                    content: "Exibe o endereço MAC atual da rede wireless 2.4GHz/5GHz."
                }, {
                    type: "title",
                    title: "Rede Wireless 2.4GHz/5GHz"
                }, {
                    type: "name",
                    title: "Status",
                    content: "Mostra se a Rede para Convidados wireless de 2.4GHz/5GHz está habilitada ou desabilitada."
                }, {
                    type: "name",
                    title: "SSID",
                    content: "Mostra o nome da rede wireless da Rede para Convidados."
                }
            ]
        },
        BASIC_NETWORK_CLIENTS: {
            TITLE: "Clientes Cabeados/Wireless",
            CONTENT: [
                {
                    type: "name",
                    title: "Nome",
                    content: "Mosta o nome do cliente conectado ao roteador."
                }, {
                    type: "name",
                    title: "Endereço IP",
                    content: "Mostra o endereço IP atribuído do cliente."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Mostra o endereço MAC do cliente."
                }
            ]
        },
        BASIC_NETWORK_PRINTER: {
            TITLE: "Impressora",
            CONTENT: [
                {
                    type: "name",
                    title: "Nome",
                    content: "Mostra o nome da a impressora conectada ao roteador via porta USB."
                }
            ]
        },
        BASIC_NETWORK_USB: {
            TITLE: "USB DISK",
            CONTENT: [
                {
                    type: "name",
                    title: "Disk USB",
                    content: "Mosta o nome do disco USB conectado ao roteador."
                }, {
                    type: "name",
                    title: "Total",
                    content: "Exibe o volume total do disco USB."
                }, {
                    type: "name",
                    title: "Disponível",
                    content: "Exibe o espaço disponível no disco USB."
                }
            ]
        },
        BASIC_INTERNET: {
            TITLE: "Internet",
            CONTENT: [
                {
                    type: "name",
                    title: "Auto Detectar",
                    content: "Clique neste botão para detectar automaticamente seu tipo de conexão de Internet atual."
                }, {
                    type: "note",
                    title: "Aviso",
                    content: "Caso não tenha certeza sobre o tipo de conexão de Internet que você possui, utilize a função de Auto Detectar ou contato seu provedor para assistência."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: IP Estático"
                }, {
                    type: "name",
                    title: "Endereço IP/Máscara de Sub-rede/Gateway Padrão/DNS Primário/DNS Secundário",
                    content: "Digite as informações fornecidas pelo provedor."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: IP Dinâmico"
                }, {
                    type: "name",
                    title: "NÃO efetuar Clonagem de endereço MAC/Clonar Endereço MAC do Computador Atual",
                    content: "Selecione se pretende clonar o endereço MAC ou não, de acordo com o seu provedor."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: PPPoE"
                }, {
                    type: "name",
                    title: "Nome de Usuário/Senha",
                    content: "Insira o Nome de Usuário/Senha oferecidos pelos seu provedor. Estes campos são sensíveis a letras mínusculas e maiúsculas."
                }, {
                    type: "title",
                    title: "Tipo de Conexão de Internet: L2TP/PPTP"
                }, {
                    type: "name",
                    title: "Nome de Usuário/Senha",
                    content: "Insira o Nome de Usuário/Senha oferecidos pelos seu provedor. Estes campos são sensíveis a letras mínusculas e maiúsculas."
                }, {
                    type: "name",
                    title: "Conexão Secundária (IP Dinâmico ou IP Estático)",
                    children: [
                        {
                            type: "name",
                            title: "IP Dinâmico",
                            content: "Selecione caso o endereço IP e a máscara de sub-rede são atribuídos automaticamente pelo provedor."
                        }, {
                            type: "name",
                            title: "IP Estático",
                            content: " Selecione se o endereço IP, máscara de sub-rede, gateway e endereços DNS são fornecidos pelo provedor, e insira as informações nos campos correspondentes. "
                        }
                    ]
                }, {
                    type: "name",
                    title: "IP de Servidor VPN/Nome de Domínio",
                    content: "Insira um endereço IP de servidor VPN ou nome de domínio oferecido pelo seu provedor."
                }
            ]
        },
        BASIC_WIRELESS: {
            TITLE: "Configurações Wireless",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Rádio Wireless",
                    content: "Selecione esta caixa para habilitar a frequência de rádio wireless 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Nome de Rede Wireless (SSID)",
                    content: "Você pode deixar o SSID padrão ou estabelecer um novo nome (até 32 caracteres). Este campo é também suscetível à letras maiúsculas e minúsculas."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Selecione esta caixa se você deseja ocultar o nome da rede 2.4GHz/5GHz (SSID) da lista de redes wireless."
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Insira uma senha wireless entre 8 e 63 caracteres ASCII, ou entre  8 e 64 hexadecimal caracteres neste campo (suscetível a letras maiúsculas e minúsculas)."
                }
            ]
        },
        BASIC_DEVICE_SETTINGS: {
            TITLE: "Configurações dos Dispositivos",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A página de Configurações do Dispositivo mostra as informações de qualquer dispositivo de armazenamento USB conectado através da porta USB. "
                }, {
                    type: "name",
                    title: "Buscar",
                    content: "Normalmente, o roteador detecta automaticamente qualquer dispositivo recém-anexado. Caso contrário, clique neste botão para procurar por algum dispositivo conectado recentemente e atualize a página com as novas informações."
                }, {
                    type: "name",
                    title: "Volume",
                    content: "Mostra o nome do volume USB."
                }, {
                    type: "name",
                    title: "Capacidade",
                    content: "Mostra a capacidade de armazenamento USB total."
                }, {
                    type: "name",
                    title: "Espaço Livre",
                    content: "Mostra o espaço livre disponível atual para armazenamento."
                }, {
                    type: "name",
                    title: "Remover com Segurança",
                    content: "Clique nesse botão para desmontar de forma segura o dispositivo de armazenamento USB antes de o desligar fisicamente do roteador .",
                    children: [
                        {
                            type: "paragraph",
                            content: "Por favor note que o botão Remover com segurança só aparece quando há um dispositivo de armazenamento USB conectado ao roteador . Além disso, lembre-se que você não pode desplugar o dispositivo USB enquanto o volume atual estiver ocupado."
                        }
                    ]
                }, {
                    type: "name",
                    title: "Ativo",
                    content: "Esta tabela aparece somente quando há um dispositivo USB de armaznemanto conectado ao roteador. Selecione para habilitar o compartilhamento de arquivos do dispositivo USB."
                }
            ]
        },
        BASIC_SHARING_SETTINGS: {
            TITLE: "Configurações de Compartilhamento",
            CONTENT: [
                {
                    type: "name",
                    title: "Rede/Nome de Servidor de Mídia",
                    content: "Mostra o nome utilizado para acessar o dispositivo de armazenamento USB conectado."
                }
            ]
        },
        BASIC_FOLDER_SHARING: {
            TITLE: "Compartilhamento de Pasta",
            CONTENT: [
                {
                    type: "name",
                    title: "Compartilhar Todos",
                    content: "Alterne para On para compartilhar todos os arquivos e pastas ou Off mpara compartilhar somente as pastas selecionadas."
                }, {
                    type: "name",
                    title: "Habilitar Autenticação",
                    content: "É recomendável habilitar autenticação para solicitar aos usuários a inserirem um nome de usuário e senha válidos para acessar as pastas de compartilhamento."
                }, {
                    type: "name",
                    title: "Nome da Pasta",
                    content: "Mostra o nome da Pasta de Compartilhamento"
                }, {
                    type: "name",
                    title: "Caminho da Pasta",
                    content: "Exibe o caminho para a pasta compartilhada."
                }, {
                    type: "name",
                    title: "Compartilhamento de Mídia",
                    content: "Indica se a pasta de compartilhamento tem permissão para compartilhamento de mídia ou não."
                }, {
                    type: "name",
                    title: "Nome do Volume",
                    content: "Mostra o nome da Pasta de Compartilhamento"
                }, {
                    type: "name",
                    title: "Status",
                    content: "Exibe o status da pasta compartilhada através do indicador lâmpada. Verde (Aceso) significa habilitado e verde (Apagado) significa desabilitado. Você pode habilitar ou desabilitar o compartilhamento clicando na lâmpada."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Modificar ou Apagar a pasta de compartilhamento correspondente."
                }, {
                    type: "name",
                    title: "Adicionar",
                    content: "Clique nesse botão para criar uma nova entrada."
                }, {
                    type: "name",
                    title: "Apagar",
                    content: "Clique nesse botão para remover a entrada selecionada da tabela."
                }, {
                    type: "name",
                    title: "Buscar",
                    content: "Clique para procurar uma pasta compartilhada."
                }, {
                    type: "name",
                    title: "Permitir Acesso à Rede para Convidados",
                    content: "Selecione permitir clientes na Rede para Convidados para acessar pastas de compartilhamentos."
                }, {
                    type: "name",
                    title: "Habilitar Autenticação",
                    content: "Selecione para solicitar usuários a acessarem as pastas compartilhadas com um nome de usuário e senha válidos."
                }, {
                    type: "name",
                    title: "Habilitar Permissão Editar",
                    content: "Selecione para permitir usuários a fazerem alterações no conteúdo da pasta."
                }, {
                    type: "name",
                    title: "Habilitar Compartilhamento de Mídia.",
                    content: "Selecione para habilitar compartilhamento de mídia."
                }
            ]
        },
        BASIC_PRINT_SERVER: {
            TITLE: "Servidor de Impressora",
            CONTENT: [
                {
                    type: "name",
                    title: "Habilitar Servidor de Impressão",
                    content: "Clique em Ativar para ativar a função de servidor de impressão."
                }, {
                    type: "name",
                    title: "Nome de Impressora",
                    content: "Mostra o nome da sua impressora conectada ao roteador."
                }, {
                    type: "step",
                    title: "Para configurar um Servidor de Impressão que pode ser utilizado através da sua rede.",
                    content: ["1.Conecte a impressora USB à porta USB do roteador através de um cabo USB.", "2.Instale o driver da impressora no seu computador. Consulte os manuais do fabricante do computador para obter instruções.", "3.Instale o Controlador de Impressão USB TP-Link a partir do CD de recursos (somente para Windows) ou baixe-o (para Windows e Mac OS X) no site oficial da TP-Link."]
                }
            ]
        },
        BASIC_PARENTAL_CONTROL: {
            TITLE: "Controle dos Pais",
            CONTENT: [
                {
                    type: "name",
                    title: "Status",
                    content: "Alterne para Habilitar para acionar função de Controle dos Pais. Por padrão, esta função é desabilitada."
                }
            ]
        },
        BASIC_PARENTAL_DEVICE: {
            TITLE: "Dispositivos Sob Controle dos Pais",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "Exibe a lista de dispositivos sob o Controle dos Pais."
                }, {
                    type: "name",
                    title: "Nome do Dispositivo",
                    content: "Exibe o nome de todos os dispositivos clientes conectados que estão atualmente sob o Controle dos Pais."
                }, {
                    type: "name",
                    title: "Endereço MAC",
                    content: "Exibe o endereço MAC de todos os dispositivos clientes conectados que estão atualmente sob o Controle dos Pais."
                }, {
                    type: "name",
                    title: "Período de Acesso à Internet",
                    content: "Exibe os períodos de tempo de acesso de restrição."
                }, {
                    type: "name",
                    title: "Descrição",
                    content: "Exibe uma breve descrição do dispositivo conectado. É uma configuração opcional."
                }, {
                    type: "name",
                    title: "Status",
                    content: "Exibe o status atual (ativado ou desativado) do Controle dos Pais da unidade correspondente."
                }, {
                    type: "name",
                    title: "Modificar",
                    content: "Exibe opções para Modificar ou Apagar o serviço correspondente."
                }, {
                    type: "step",
                    title: "Para restringir um dispositivo de um novo cliente",
                    content: [
                        "1.Clique em Adicionar (Add).",
                        "2.Clique em Ver Dispositivos Existentes e escolha um dispositivo conectado atualmente na Lista de Dispositivos de Acesso; ou digite o nome do dispositivo e o endereço MAC manualmente para adicionar um dispositivo que não está conectado.",
                        "3.Clique no ícone de Tempo de Acesso à Internet para especificar um período enquanto a restrição for aplicável.",
                        "4. Insira uma breve descrição no campo Descrição. (Opcional)",
                        "5. Selecione Habilitar.",
                        "6. Clique em OK para salvar esta entrada."
                    ]
                }, {
                    type: "paragraph",
                    content: "Para modificar ou apagar uma entrada de Controle dos Pais, clique no ícone Editar ou na Lixeira para apagar a entrada correspondente."
                }, {
                    type: "paragraph",
                    content: "Para excluir várias entradas, selecione todas as entradas e clique em Apagar acima da tabela."
                }
            ]
        },
        BASIC_GUEST_NETWORK: {
            TITLE: "Rede para Convidados",
            CONTENT: [
                {
                    type: "paragraph",
                    content: "A Rede para Convidados permite-lhe criar uma rede separada com um nome diferente de rede wireless (SSID) e a senha que os clientes podem usar para acessarem a sua rede Wi-Fi."
                }, {
                    type: "name",
                    title: "Permitir convidados verem uns aos outros",
                    content: "Selecione esta caixa para permitir dispositivos wireless na Rede para Convidados de verem uns aos outros."
                }, {
                    type: "name",
                    title: "Não permitir que convidados possam gerenciar minha rede. ",
                    content: "Selecione esta opção para prevenir convidados de se logarem na interface de gerenciamento web."
                }, {
                    type: "name",
                    title: "Habilitar Rede para Convidados",
                    content: "Selecione esta caixa de seleção para habilitar a função de Rede para Convidados 2.4GHz/5GHz."
                }, {
                    type: "name",
                    title: "Nome de Rede Wireless (SSID)",
                    content: "Ou use o padrão SSID de Convidado ou crie um novo nome (até 32 caracteres)."
                }, {
                    type: "name",
                    title: "Ocultar SSID",
                    content: "Selecione esta opção se você deseja ocultar o SSID de convidados a partir da lista de redes Wi-Fi."
                }, {
                    type: "name",
                    title: "Senha",
                    content: "Crie uma senha entre 8 e 63 caracteres ASCII ou entre 8 e 64 caracteres hexadecimais (0-9, a-f, A- F), para proteger a Rede para Convidados."
                }
            ]
        },
        "": ""
    };
})(jQuery);
